/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;

class ChainingContainerValueExtractor<C, U, V>
implements ContainerValueExtractor<C, V> {
    private final ContainerValueExtractor<C, U> parent;
    private final ContainerValueExtractor<? super U, V> chained;

    ChainingContainerValueExtractor(ContainerValueExtractor<C, U> parent, ContainerValueExtractor<? super U, V> chained) {
        this.parent = parent;
        this.chained = chained;
    }

    @Override
    public Stream<V> extract(C container) {
        return this.parent.extract(container).flatMap(this.chained::extract);
    }

    public ContainerValueExtractor<C, U> getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        this.appendToString(builder, this, true);
        builder.append("]");
        return builder.toString();
    }

    private void appendToString(StringBuilder builder, ContainerValueExtractor<?, ?> extractor, boolean first) {
        if (extractor instanceof ChainingContainerValueExtractor) {
            ChainingContainerValueExtractor chaining = (ChainingContainerValueExtractor)extractor;
            this.appendToString(builder, chaining.parent, first);
            this.appendToString(builder, chaining.chained, false);
        } else {
            if (!first) {
                builder.append(", ");
            }
            builder.append(extractor);
        }
    }
}

