/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.builtin.ArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.CollectionElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.IterableElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.MapValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.OptionalDoubleValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.OptionalIntValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.OptionalLongValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.OptionalValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ChainingContainerValueExtractor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExtractingTypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.mapper.pojo.util.impl.GenericTypeContext;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ContainerValueExtractorBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final TypePatternMatcherFactory typePatternMatcherFactory;
    private final FirstMatchingExtractorContributor firstMatchingExtractorContributor = new FirstMatchingExtractorContributor();
    private Map<Class<? extends ContainerValueExtractor>, ExtractorContributor> extractorContributorCache = new HashMap<Class<? extends ContainerValueExtractor>, ExtractorContributor>();

    public ContainerValueExtractorBinder(MappingBuildContext buildContext, TypePatternMatcherFactory typePatternMatcherFactory) {
        this.beanProvider = buildContext.getServiceManager().getBeanProvider();
        this.typePatternMatcherFactory = typePatternMatcherFactory;
        this.addDefaultExtractor(MapValueExtractor.class);
        this.addDefaultExtractor(CollectionElementExtractor.class);
        this.addDefaultExtractor(IterableElementExtractor.class);
        this.addDefaultExtractor(OptionalValueExtractor.class);
        this.addDefaultExtractor(OptionalIntValueExtractor.class);
        this.addDefaultExtractor(OptionalLongValueExtractor.class);
        this.addDefaultExtractor(OptionalDoubleValueExtractor.class);
        this.addDefaultExtractor(ArrayElementExtractor.class);
    }

    public <C> Optional<BoundContainerValueExtractorPath<C, ?>> tryBindPath(PojoGenericTypeModel<C> sourceType, ContainerValueExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (Class<? extends ContainerValueExtractor> clazz : extractorPath.getExplicitExtractorClasses()) {
                ExtractorContributor extractorContributor = this.getExtractorContributorForClass(clazz);
                if (extractorContributor.tryAppend(state)) continue;
                return Optional.empty();
            }
        }
        return Optional.of(state.build());
    }

    public <C> BoundContainerValueExtractorPath<C, ?> bindPath(PojoGenericTypeModel<C> sourceType, ContainerValueExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (Class<? extends ContainerValueExtractor> clazz : extractorPath.getExplicitExtractorClasses()) {
                ExtractorContributor extractorContributor = this.getExtractorContributorForClass(clazz);
                if (extractorContributor.tryAppend(state)) continue;
                throw log.invalidContainerValueExtractorForType(clazz, ((ExtractorResolutionState)state).extractedType);
            }
        }
        return state.build();
    }

    public <C, V> Optional<ContainerValueExtractor<? super C, V>> tryCreate(BoundContainerValueExtractorPath<C, V> boundPath) {
        ChainingContainerValueExtractor extractor = null;
        for (Class<? extends ContainerValueExtractor> clazz : boundPath.getExtractorPath().getExplicitExtractorClasses()) {
            ChainingContainerValueExtractor newExtractor = (ChainingContainerValueExtractor)this.beanProvider.getBean(clazz, ContainerValueExtractor.class);
            if (extractor == null) {
                extractor = newExtractor;
                continue;
            }
            extractor = new ChainingContainerValueExtractor(extractor, newExtractor);
        }
        if (extractor == null) {
            return Optional.empty();
        }
        return Optional.of(extractor);
    }

    public <C, V> ContainerValueExtractor<? super C, V> create(BoundContainerValueExtractorPath<C, V> boundPath) {
        if (boundPath.getExtractorPath().isEmpty()) {
            throw new AssertionFailure("Received a request to create extractors, but the extractor path was empty. There is probably a bug in Hibernate Search.");
        }
        return this.tryCreate(boundPath).get();
    }

    public boolean isDefaultExtractorPath(PojoGenericTypeModel<?> sourceType, ContainerValueExtractorPath extractorPath) {
        Optional<BoundContainerValueExtractorPath<?, ?>> boundDefaultExtractorPathOptional = this.tryBindPath(sourceType, ContainerValueExtractorPath.defaultExtractors());
        return boundDefaultExtractorPathOptional.isPresent() && extractorPath.equals(boundDefaultExtractorPathOptional.get().getExtractorPath());
    }

    private void addDefaultExtractor(Class<? extends ContainerValueExtractor> extractorClass) {
        ExtractorContributor extractorContributor = this.getExtractorContributorForClass(extractorClass);
        this.firstMatchingExtractorContributor.addCandidate(extractorContributor);
    }

    private ExtractorContributor getExtractorContributorForClass(Class<? extends ContainerValueExtractor> extractorClass) {
        return this.extractorContributorCache.computeIfAbsent(extractorClass, this::createExtractorContributorForClass);
    }

    private ExtractorContributor createExtractorContributorForClass(Class<? extends ContainerValueExtractor> extractorClass) {
        ExtractingTypePatternMatcher typePatternMatcher;
        GenericTypeContext typeContext = new GenericTypeContext(extractorClass);
        Type typePattern = typeContext.resolveTypeArgument(ContainerValueExtractor.class, 0).orElseThrow(() -> log.cannotInferContainerValueExtractorClassTypePattern(extractorClass));
        Type typeToExtract = typeContext.resolveTypeArgument(ContainerValueExtractor.class, 1).orElseThrow(() -> log.cannotInferContainerValueExtractorClassTypePattern(extractorClass));
        try {
            typePatternMatcher = this.typePatternMatcherFactory.createExtractingMatcher(typePattern, typeToExtract);
        }
        catch (UnsupportedOperationException e) {
            throw log.cannotInferContainerValueExtractorClassTypePattern(extractorClass);
        }
        return new SingleExtractorContributor(typePatternMatcher, extractorClass);
    }

    private static class ExtractorResolutionState<C> {
        private final List<Class<? extends ContainerValueExtractor>> extractorClasses = new ArrayList<Class<? extends ContainerValueExtractor>>();
        private final PojoGenericTypeModel<C> sourceType;
        private PojoGenericTypeModel<?> extractedType;

        ExtractorResolutionState(PojoGenericTypeModel<C> sourceType) {
            this.sourceType = sourceType;
            this.extractedType = sourceType;
        }

        void append(Class<? extends ContainerValueExtractor> extractorClass, PojoGenericTypeModel<?> extractedType) {
            this.extractorClasses.add(extractorClass);
            this.extractedType = extractedType;
        }

        BoundContainerValueExtractorPath<C, ?> build() {
            return new BoundContainerValueExtractorPath(this.sourceType, ContainerValueExtractorPath.explicitExtractors(this.extractorClasses), this.extractedType);
        }
    }

    private static class FirstMatchingExtractorContributor
    implements ExtractorContributor {
        private final List<ExtractorContributor> candidates = new ArrayList<ExtractorContributor>();

        private FirstMatchingExtractorContributor() {
        }

        void addCandidate(ExtractorContributor contributor) {
            this.candidates.add(contributor);
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            for (ExtractorContributor extractorContributor : this.candidates) {
                if (!extractorContributor.tryAppend(state)) continue;
                this.tryAppend(state);
                return true;
            }
            return false;
        }
    }

    private class SingleExtractorContributor
    implements ExtractorContributor {
        private final ExtractingTypePatternMatcher typePatternMatcher;
        private final Class<? extends ContainerValueExtractor> extractorClass;

        SingleExtractorContributor(ExtractingTypePatternMatcher typePatternMatcher, Class<? extends ContainerValueExtractor> extractorClass) {
            this.typePatternMatcher = typePatternMatcher;
            this.extractorClass = extractorClass;
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            Optional<PojoGenericTypeModel<?>> resultTypeOptional = this.typePatternMatcher.extract(((ExtractorResolutionState)state).extractedType);
            if (resultTypeOptional.isPresent()) {
                state.append(this.extractorClass, resultTypeOptional.get());
                return true;
            }
            return false;
        }
    }

    private static interface ExtractorContributor {
        public boolean tryAppend(ExtractorResolutionState<?> var1);
    }
}

