/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.spi;

import java.lang.annotation.Annotation;
import org.hibernate.search.engine.logging.spi.AbstractSimpleEventContextElement;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.mapper.pojo.logging.impl.PojoEventContextMessages;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.EventContextElement;
import org.jboss.logging.Messages;

public final class PojoEventContexts {
    private static final PojoEventContextMessages MESSAGES = (PojoEventContextMessages)Messages.getBundle(PojoEventContextMessages.class);

    private PojoEventContexts() {
    }

    public static EventContext fromType(PojoRawTypeModel<?> typeModel) {
        return EventContexts.fromType(typeModel);
    }

    public static EventContext fromPath(PojoModelPath unboundPath) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<PojoModelPath>(unboundPath){

            public String render(PojoModelPath param) {
                String pathString = param == null ? "" : param.toPathString();
                return MESSAGES.path(pathString);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromAnnotation(Annotation annotation) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Annotation>(annotation){

            public String render(Annotation annotation) {
                String annotationString = annotation.toString();
                return MESSAGES.annotation(annotationString);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }
}

