/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldContext;
import org.hibernate.search.engine.backend.document.model.dsl.StandardIndexSchemaFieldTypedContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.FieldModelContributor;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexModelBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.IdentifierBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PropertyBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.RoutingKeyBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.TypeBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.ValueBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerValueExtractorBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundPropertyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundTypeBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BridgeBuildContextImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoValueBridgeToIndexFieldValueConverter;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelPropertyRootElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.util.impl.GenericTypeContext;
import org.hibernate.search.mapper.pojo.util.impl.ReflectionUtils;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class PojoIndexModelBinderImpl
implements PojoIndexModelBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BridgeBuildContext bridgeBuildContext;
    private final ContainerValueExtractorBinder extractorBinder;
    private final BridgeResolver bridgeResolver;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;

    PojoIndexModelBinderImpl(MappingBuildContext buildContext, ContainerValueExtractorBinder extractorBinder, BridgeResolver bridgeResolver, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider) {
        this.bridgeBuildContext = new BridgeBuildContextImpl(buildContext);
        this.extractorBinder = extractorBinder;
        this.bridgeResolver = bridgeResolver;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
    }

    @Override
    public <C> BoundContainerValueExtractorPath<C, ?> bindExtractorPath(PojoGenericTypeModel<C> pojoGenericTypeModel, ContainerValueExtractorPath extractorPath) {
        return this.extractorBinder.bindPath(pojoGenericTypeModel, extractorPath);
    }

    @Override
    public <C> Optional<BoundContainerValueExtractorPath<C, ?>> tryBindExtractorPath(PojoGenericTypeModel<C> pojoGenericTypeModel, ContainerValueExtractorPath extractorPath) {
        return this.extractorBinder.tryBindPath(pojoGenericTypeModel, extractorPath);
    }

    @Override
    public <C, V> Optional<? extends ContainerValueExtractor<? super C, V>> tryCreateExtractors(BoundContainerValueExtractorPath<C, V> boundExtractorPath) {
        return this.extractorBinder.tryCreate(boundExtractorPath);
    }

    @Override
    public <C, V> ContainerValueExtractor<? super C, V> createExtractors(BoundContainerValueExtractorPath<C, V> boundExtractorPath) {
        return this.extractorBinder.create(boundExtractorPath);
    }

    @Override
    public <I> IdentifierBridge<I> addIdentifierBridge(BoundPojoModelPathPropertyNode<?, I> modelPath, BridgeBuilder<? extends IdentifierBridge<?>> builder) {
        PojoGenericTypeModel<I> typeModel = modelPath.valueWithoutExtractors().getTypeModel();
        BridgeBuilder<IdentifierBridge<?>> defaultedBuilder = builder;
        if (builder == null) {
            defaultedBuilder = this.bridgeResolver.resolveIdentifierBridgeForType(typeModel);
        }
        IdentifierBridge<?> bridge = defaultedBuilder.build(this.bridgeBuildContext);
        bridge.bind(new IdentifierBridgeBindingContextImpl<I>(new PojoModelValueElement<I>(typeModel)));
        return bridge;
    }

    @Override
    public <T> BoundRoutingKeyBridge<T> addRoutingKeyBridge(IndexModelBindingContext bindingContext, BoundPojoModelPathTypeNode<T> modelPath, BridgeBuilder<? extends RoutingKeyBridge> builder) {
        RoutingKeyBridge bridge = builder.build(this.bridgeBuildContext);
        PojoModelTypeRootElement<T> pojoModelRootElement = new PojoModelTypeRootElement<T>(modelPath, this.typeAdditionalMetadataProvider);
        bridge.bind(new RoutingKeyBridgeBindingContextImpl(pojoModelRootElement));
        bindingContext.explicitRouting();
        return new BoundRoutingKeyBridge<T>(bridge, pojoModelRootElement);
    }

    @Override
    public <T> Optional<BoundTypeBridge<T>> addTypeBridge(IndexModelBindingContext bindingContext, BoundPojoModelPathTypeNode<T> modelPath, BridgeBuilder<? extends TypeBridge> builder) {
        TypeBridge bridge = builder.build(this.bridgeBuildContext);
        PojoIndexSchemaContributionListener listener = new PojoIndexSchemaContributionListener();
        PojoModelTypeRootElement<T> pojoModelRootElement = new PojoModelTypeRootElement<T>(modelPath, this.typeAdditionalMetadataProvider);
        bridge.bind(new TypeBridgeBindingContextImpl(pojoModelRootElement, bindingContext.getSchemaElement((IndexSchemaContributionListener)listener)));
        if (listener.schemaContributed) {
            return Optional.of(new BoundTypeBridge<T>(bridge, pojoModelRootElement));
        }
        bridge.close();
        return Optional.empty();
    }

    @Override
    public <P> Optional<BoundPropertyBridge<P>> addPropertyBridge(IndexModelBindingContext bindingContext, BoundPojoModelPathPropertyNode<?, P> modelPath, BridgeBuilder<? extends PropertyBridge> builder) {
        PropertyBridge bridge = builder.build(this.bridgeBuildContext);
        PojoIndexSchemaContributionListener listener = new PojoIndexSchemaContributionListener();
        PojoModelPropertyRootElement<P> pojoModelRootElement = new PojoModelPropertyRootElement<P>(modelPath, this.typeAdditionalMetadataProvider);
        bridge.bind(new PropertyBridgeBindingContextImpl(pojoModelRootElement, bindingContext.getSchemaElement((IndexSchemaContributionListener)listener)));
        if (listener.schemaContributed) {
            return Optional.of(new BoundPropertyBridge<P>(bridge, pojoModelRootElement));
        }
        bridge.close();
        return Optional.empty();
    }

    @Override
    public <V> Optional<BoundValueBridge<V, ?>> addValueBridge(IndexModelBindingContext bindingContext, BoundPojoModelPathValueNode<?, ?, V> modelPath, BridgeBuilder<? extends ValueBridge<?, ?>> builder, String relativeFieldName, FieldModelContributor contributor) {
        PojoGenericTypeModel<V> valueTypeModel = modelPath.getTypeModel();
        BridgeBuilder<ValueBridge<?, ?>> defaultedBuilder = builder;
        if (builder == null) {
            defaultedBuilder = this.bridgeResolver.resolveValueBridgeForType(valueTypeModel);
        }
        ValueBridge<?, ?> bridge = defaultedBuilder.build(this.bridgeBuildContext);
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Class bridgeParameterType = bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> log.unableToInferValueBridgeInputType(bridge));
        if (!valueTypeModel.getRawType().isSubTypeOf(bridgeParameterType)) {
            throw log.invalidInputTypeForValueBridge(bridge, valueTypeModel);
        }
        ValueBridge<?, ?> typedBridge = bridge;
        return this.doAddValueBridge(bindingContext, typedBridge, bridgeTypeContext, valueTypeModel, relativeFieldName, contributor);
    }

    private <V, F> Optional<BoundValueBridge<V, ?>> doAddValueBridge(IndexModelBindingContext bindingContext, ValueBridge<? super V, F> bridge, GenericTypeContext bridgeTypeContext, PojoGenericTypeModel<V> valueTypeModel, String relativeFieldName, FieldModelContributor contributor) {
        PojoIndexSchemaContributionListener listener = new PojoIndexSchemaContributionListener();
        IndexSchemaFieldContext fieldContext = bindingContext.getSchemaElement((IndexSchemaContributionListener)listener).field(relativeFieldName);
        ValueBridgeBindingContextImpl<V> bridgeBindingContext = new ValueBridgeBindingContextImpl<V>(new PojoModelValueElement<V>(valueTypeModel), fieldContext);
        StandardIndexSchemaFieldTypedContext typedFieldContext = bridge.bind(bridgeBindingContext);
        if (typedFieldContext == null) {
            Class returnType = bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 1).map(ReflectionUtils::getRawType).orElseThrow(() -> log.unableToInferValueBridgeIndexFieldType(bridge));
            typedFieldContext = fieldContext.as(returnType);
        }
        typedFieldContext.dslConverter(new PojoValueBridgeToIndexFieldValueConverter(bridge));
        contributor.contribute(typedFieldContext);
        IndexFieldAccessor indexFieldAccessor = typedFieldContext.createAccessor();
        if (listener.schemaContributed) {
            return Optional.of(new BoundValueBridge<V, F>(bridge, indexFieldAccessor));
        }
        bridge.close();
        return Optional.empty();
    }

    private class PojoIndexSchemaContributionListener
    implements IndexSchemaContributionListener {
        private boolean schemaContributed = false;

        private PojoIndexSchemaContributionListener() {
        }

        public void onSchemaContributed() {
            this.schemaContributed = true;
        }
    }
}

