/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexManagerBuildingState;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexModelBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.impl.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.impl.RoutingKeyBridgeRoutingKeyProvider;
import org.hibernate.search.mapper.pojo.mapping.impl.RoutingKeyProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.LoggerFactory;

class PojoIndexedTypeManagerBuilder<E, D extends DocumentElement> {
    private static Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final PojoTypeAdditionalMetadata typeAdditionalMetadata;
    private final PojoMappingHelper mappingHelper;
    private final IndexManagerBuildingState<D> indexManagerBuildingState;
    private final PojoIdentityMappingCollectorImpl identityMappingCollector;
    private final PojoIndexingProcessorTypeNodeBuilder<E> processorBuilder;
    private PojoIndexingProcessor<E> preBuiltIndexingProcessor;
    private boolean closed = false;

    PojoIndexedTypeManagerBuilder(PojoRawTypeModel<E> typeModel, PojoTypeAdditionalMetadata typeAdditionalMetadata, PojoMappingHelper mappingHelper, IndexManagerBuildingState<D> indexManagerBuildingState, IdentifierMapping<?, E> defaultIdentifierMapping) {
        this.typeModel = typeModel;
        this.typeAdditionalMetadata = typeAdditionalMetadata;
        this.mappingHelper = mappingHelper;
        this.indexManagerBuildingState = indexManagerBuildingState;
        this.identityMappingCollector = new PojoIdentityMappingCollectorImpl(defaultIdentifierMapping);
        IndexModelBindingContext bindingContext = indexManagerBuildingState.getRootBindingContext();
        this.processorBuilder = new PojoIndexingProcessorTypeNodeBuilder<E>(BoundPojoModelPath.root(typeModel), mappingHelper, bindingContext, Optional.of(this.identityMappingCollector));
    }

    void closeOnFailure() {
        if (this.closed) {
            return;
        }
        try (Closer closer = new Closer();){
            closer.push(PojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.processorBuilder);
            closer.push(PojoIdentityMappingCollectorImpl::closeOnFailure, (Object)this.identityMappingCollector);
            closer.push(PojoIndexingProcessor::close, this.preBuiltIndexingProcessor);
            this.closed = true;
        }
    }

    PojoMappingCollectorTypeNode asCollector() {
        return this.processorBuilder;
    }

    void preBuild(PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (this.preBuiltIndexingProcessor != null) {
            throw new AssertionFailure("Internal error - preBuild should be called only once");
        }
        PojoIndexingDependencyCollectorTypeNode<E> dependencyCollector = reindexingResolverBuildingHelper.createDependencyCollector(this.typeModel);
        this.preBuiltIndexingProcessor = this.processorBuilder.build(dependencyCollector).orElseGet(PojoIndexingProcessor::noOp);
    }

    void buildAndAddTo(PojoIndexedTypeManagerContainer.Builder typeManagersBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoTypeAdditionalMetadata typeAdditionalMetadata) {
        RoutingKeyBridge routingKeyBridge;
        if (this.preBuiltIndexingProcessor == null) {
            throw new AssertionFailure("Internal error - preBuild should be called before buildAndAddTo");
        }
        IdentifierMapping identifierMapping = this.identityMappingCollector.identifierMapping;
        if (identifierMapping == null) {
            Optional<BoundPojoModelPathPropertyNode<E, ?>> entityIdPathOptional = this.getEntityIdentifierPath();
            if (entityIdPathOptional.isPresent()) {
                BoundPojoModelPathPropertyNode<E, ?> entityIdPath = entityIdPathOptional.get();
                this.identityMappingCollector.defaultIdentifierBridge(this.mappingHelper, entityIdPath);
                identifierMapping = this.identityMappingCollector.identifierMapping;
            } else {
                throw log.missingIdentifierMapping(this.typeModel);
            }
        }
        RoutingKeyProvider routingKeyProvider = (routingKeyBridge = this.identityMappingCollector.routingKeyBridge) == null ? RoutingKeyProvider.alwaysNull() : new RoutingKeyBridgeRoutingKeyProvider(routingKeyBridge);
        PojoPathFilterFactory<Set<String>> pathFilterFactory = typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(this.typeModel)).getPathFilterFactory();
        Optional<PojoImplicitReindexingResolver<E, Set<String>>> reindexingResolverOptional = reindexingResolverBuildingHelper.build(this.typeModel, pathFilterFactory);
        PojoIndexedTypeManager typeManager = new PojoIndexedTypeManager(this.typeModel.getJavaClass(), this.typeModel.getCaster(), identifierMapping, routingKeyProvider, this.preBuiltIndexingProcessor, this.indexManagerBuildingState.build(), reindexingResolverOptional.orElseGet(PojoImplicitReindexingResolver::noOp));
        log.createdPojoIndexedTypeManager(typeManager);
        typeManagersBuilder.add(this.indexManagerBuildingState.getIndexName(), this.typeModel, typeManager);
        this.closed = true;
    }

    private Optional<BoundPojoModelPathPropertyNode<E, ?>> getEntityIdentifierPath() {
        Optional<String> entityIdPropertyName = this.typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(this.typeModel)).getEntityIdPropertyName();
        if (entityIdPropertyName.isPresent()) {
            PojoPropertyModel<?> propertyModel = this.typeModel.getProperty(entityIdPropertyName.get());
            return Optional.of(BoundPojoModelPath.root(this.typeModel).property(propertyModel.getHandle()));
        }
        return Optional.empty();
    }

    private class PojoIdentityMappingCollectorImpl
    implements PojoIdentityMappingCollector {
        private IdentifierMapping<?, E> identifierMapping;
        private RoutingKeyBridge routingKeyBridge;

        PojoIdentityMappingCollectorImpl(IdentifierMapping<?, E> identifierMapping) {
            this.identifierMapping = identifierMapping;
        }

        void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.push(IdentifierMapping::close, this.identifierMapping);
                closer.push(RoutingKeyBridge::close, (Object)this.routingKeyBridge);
            }
        }

        @Override
        public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, IdentifierBridge<T> bridge) {
            PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
            this.identifierMapping = new PropertyIdentifierMapping(propertyModel.getTypeModel().getRawType().getCaster(), propertyModel.getHandle(), bridge);
        }

        <T> void defaultIdentifierBridge(PojoMappingHelper mappingHelper, BoundPojoModelPathPropertyNode<?, T> entityIdPath) {
            this.identifierBridge(entityIdPath, mappingHelper.getIndexModelBinder().addIdentifierBridge(entityIdPath, null));
        }

        @Override
        public void routingKeyBridge(RoutingKeyBridge bridge) {
            this.routingKeyBridge = bridge;
        }
    }
}

