/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.util.Optional;
import org.hibernate.search.engine.backend.document.converter.ToIndexFieldValueConverter;
import org.hibernate.search.engine.backend.document.converter.runtime.ToIndexFieldValueConvertContext;
import org.hibernate.search.engine.backend.document.converter.runtime.ToIndexFieldValueConvertContextExtension;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;

final class PojoValueBridgeToIndexFieldValueConverter<U, V extends U, F>
implements ToIndexFieldValueConverter<V, F> {
    private final ValueBridge<U, F> bridge;

    PojoValueBridgeToIndexFieldValueConverter(ValueBridge<U, F> bridge) {
        this.bridge = bridge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bridge + "]";
    }

    public F convert(V value, ToIndexFieldValueConvertContext context) {
        return this.bridge.toIndexedValue(value, (ValueBridgeToIndexedValueContext)context.extension((ToIndexFieldValueConvertContextExtension)PojoValueBridgeContextExtension.INSTANCE));
    }

    public F convertUnknown(Object value, ToIndexFieldValueConvertContext context) {
        return this.bridge.toIndexedValue(this.bridge.cast(value), (ValueBridgeToIndexedValueContext)context.extension((ToIndexFieldValueConvertContextExtension)PojoValueBridgeContextExtension.INSTANCE));
    }

    public boolean isCompatibleWith(ToIndexFieldValueConverter<?, ?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoValueBridgeToIndexFieldValueConverter castedOther = (PojoValueBridgeToIndexFieldValueConverter)other;
        return this.bridge.isCompatibleWith(castedOther.bridge);
    }

    private static class PojoValueBridgeContextExtension
    implements ToIndexFieldValueConvertContextExtension<ValueBridgeToIndexedValueContext> {
        private static final PojoValueBridgeContextExtension INSTANCE = new PojoValueBridgeContextExtension();

        private PojoValueBridgeContextExtension() {
        }

        public Optional<ValueBridgeToIndexedValueContext> extendOptional(ToIndexFieldValueConvertContext original, MappingContextImplementor mappingContext) {
            if (mappingContext instanceof AbstractPojoMappingContextImplementor) {
                AbstractPojoMappingContextImplementor pojoMappingContext = (AbstractPojoMappingContextImplementor)mappingContext;
                return Optional.of(pojoMappingContext.getToIndexedValueContext());
            }
            return Optional.empty();
        }
    }
}

