/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.logging.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.declaration.MarkerMapping;
import org.hibernate.search.mapper.pojo.bridge.declaration.MarkerMappingBuilderReference;
import org.hibernate.search.mapper.pojo.bridge.declaration.PropertyBridgeAnnotationBuilderReference;
import org.hibernate.search.mapper.pojo.bridge.declaration.PropertyBridgeMapping;
import org.hibernate.search.mapper.pojo.bridge.declaration.PropertyBridgeReference;
import org.hibernate.search.mapper.pojo.bridge.declaration.RoutingKeyBridgeAnnotationBuilderReference;
import org.hibernate.search.mapper.pojo.bridge.declaration.RoutingKeyBridgeMapping;
import org.hibernate.search.mapper.pojo.bridge.declaration.RoutingKeyBridgeReference;
import org.hibernate.search.mapper.pojo.bridge.declaration.TypeBridgeAnnotationBuilderReference;
import org.hibernate.search.mapper.pojo.bridge.declaration.TypeBridgeMapping;
import org.hibernate.search.mapper.pojo.bridge.declaration.TypeBridgeReference;
import org.hibernate.search.mapper.pojo.bridge.impl.BeanResolverBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.AnnotationBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.AnnotationMarkerBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.MarkerBuilder;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ContainerValueExtractorBeanReference;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IdentifierBridgeBeanReference;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IdentifierBridgeBuilderBeanReference;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyValue;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ValueBridgeBeanReference;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ValueBridgeBuilderBeanReference;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.impl.common.LoggerFactory;

class AnnotationProcessorHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final FailureCollector rootFailureCollector;

    AnnotationProcessorHelper(BeanProvider beanProvider, FailureCollector rootFailureCollector) {
        this.beanProvider = beanProvider;
        this.rootFailureCollector = rootFailureCollector;
    }

    FailureCollector getRootFailureCollector() {
        return this.rootFailureCollector;
    }

    Optional<PojoModelPathValueNode> getPojoModelPathValueNode(ObjectPath objectPath) {
        PropertyValue[] inversePathElements = objectPath.value();
        PojoModelPathValueNode inversePath = null;
        for (PropertyValue element : inversePathElements) {
            String inversePropertyName = element.propertyName();
            ContainerValueExtractorPath inverseExtractorPath = this.getExtractorPath(element.extractors());
            inversePath = inversePath == null ? PojoModelPath.fromRoot(inversePropertyName).value(inverseExtractorPath) : inversePath.property(inversePropertyName).value(inverseExtractorPath);
        }
        return Optional.ofNullable(inversePath);
    }

    ContainerValueExtractorPath getExtractorPath(ContainerValueExtractorBeanReference[] extractors) {
        if (extractors.length == 0) {
            return ContainerValueExtractorPath.noExtractors();
        }
        if (extractors.length == 1 && ContainerValueExtractorBeanReference.DefaultExtractors.class.equals(extractors[0].type())) {
            return ContainerValueExtractorPath.defaultExtractors();
        }
        return ContainerValueExtractorPath.explicitExtractors(Arrays.stream(extractors).map(ContainerValueExtractorBeanReference::type).collect(Collectors.toList()));
    }

    <A extends Annotation> MarkerBuilder createMarkerBuilder(A annotation) {
        MarkerMapping markerMapping = annotation.annotationType().getAnnotation(MarkerMapping.class);
        MarkerMappingBuilderReference markerBuilderReferenceAnnotation = markerMapping.builder();
        BeanReference markerBuilderReference = this.toBeanReference(markerBuilderReferenceAnnotation.name(), markerBuilderReferenceAnnotation.type(), MarkerMappingBuilderReference.UndefinedImplementationType.class).orElseThrow(() -> log.missingBuilderReferenceInMarkerMapping(MarkerMapping.class, annotation.annotationType()));
        AnnotationMarkerBuilder builder = (AnnotationMarkerBuilder)this.beanProvider.getBean(markerBuilderReference, AnnotationMarkerBuilder.class);
        builder.initialize(annotation);
        return builder;
    }

    BridgeBuilder<? extends IdentifierBridge<?>> createIdentifierBridgeBuilder(DocumentId annotation, PojoPropertyModel<?> annotationHolder) {
        IdentifierBridgeBeanReference bridgeReferenceAnnotation = annotation.identifierBridge();
        Optional<BeanReference> bridgeReference = this.toBeanReference(bridgeReferenceAnnotation.name(), bridgeReferenceAnnotation.type(), IdentifierBridgeBeanReference.UndefinedImplementationType.class);
        IdentifierBridgeBuilderBeanReference bridgeBuilderReferenceAnnotation = annotation.identifierBridgeBuilder();
        Optional<BeanReference> bridgeBuilderReference = this.toBeanReference(bridgeBuilderReferenceAnnotation.name(), bridgeBuilderReferenceAnnotation.type(), IdentifierBridgeBuilderBeanReference.UndefinedImplementationType.class);
        if (bridgeReference.isPresent() && bridgeBuilderReference.isPresent()) {
            throw log.invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference(annotationHolder.getName());
        }
        if (bridgeReference.isPresent()) {
            BeanResolverBridgeBuilder<IdentifierBridge> castedBuilder = new BeanResolverBridgeBuilder<IdentifierBridge>(IdentifierBridge.class, bridgeReference.get());
            return castedBuilder;
        }
        if (bridgeBuilderReference.isPresent()) {
            return (BridgeBuilder)this.beanProvider.getBean(bridgeBuilderReference.get(), BridgeBuilder.class);
        }
        return null;
    }

    <A extends Annotation> BridgeBuilder<? extends RoutingKeyBridge> createRoutingKeyBridgeBuilder(A annotation) {
        RoutingKeyBridgeMapping bridgeMapping = annotation.annotationType().getAnnotation(RoutingKeyBridgeMapping.class);
        RoutingKeyBridgeReference bridgeReferenceAnnotation = bridgeMapping.bridge();
        RoutingKeyBridgeAnnotationBuilderReference bridgeBuilderReferenceAnnotation = bridgeMapping.builder();
        return this.createAnnotationMappedBridgeBuilder(RoutingKeyBridgeMapping.class, RoutingKeyBridge.class, annotation, this.toBeanReference(bridgeReferenceAnnotation.name(), bridgeReferenceAnnotation.type(), RoutingKeyBridgeReference.UndefinedImplementationType.class), this.toBeanReference(bridgeBuilderReferenceAnnotation.name(), bridgeBuilderReferenceAnnotation.type(), RoutingKeyBridgeAnnotationBuilderReference.UndefinedImplementationType.class));
    }

    <A extends Annotation> BridgeBuilder<? extends TypeBridge> createTypeBridgeBuilder(A annotation) {
        TypeBridgeMapping bridgeMapping = annotation.annotationType().getAnnotation(TypeBridgeMapping.class);
        TypeBridgeReference bridgeReferenceAnnotation = bridgeMapping.bridge();
        TypeBridgeAnnotationBuilderReference bridgeBuilderReferenceAnnotation = bridgeMapping.builder();
        return this.createAnnotationMappedBridgeBuilder(TypeBridgeMapping.class, TypeBridge.class, annotation, this.toBeanReference(bridgeReferenceAnnotation.name(), bridgeReferenceAnnotation.type(), TypeBridgeReference.UndefinedImplementationType.class), this.toBeanReference(bridgeBuilderReferenceAnnotation.name(), bridgeBuilderReferenceAnnotation.type(), TypeBridgeAnnotationBuilderReference.UndefinedImplementationType.class));
    }

    <A extends Annotation> BridgeBuilder<? extends PropertyBridge> createPropertyBridgeBuilder(A annotation) {
        PropertyBridgeMapping bridgeMapping = annotation.annotationType().getAnnotation(PropertyBridgeMapping.class);
        PropertyBridgeReference bridgeReferenceAnnotation = bridgeMapping.bridge();
        PropertyBridgeAnnotationBuilderReference bridgeBuilderReferenceAnnotation = bridgeMapping.builder();
        return this.createAnnotationMappedBridgeBuilder(PropertyBridgeMapping.class, PropertyBridge.class, annotation, this.toBeanReference(bridgeReferenceAnnotation.name(), bridgeReferenceAnnotation.type(), PropertyBridgeReference.UndefinedImplementationType.class), this.toBeanReference(bridgeBuilderReferenceAnnotation.name(), bridgeBuilderReferenceAnnotation.type(), PropertyBridgeAnnotationBuilderReference.UndefinedImplementationType.class));
    }

    BridgeBuilder<? extends ValueBridge<?, ?>> createValueBridgeBuilder(ValueBridgeBeanReference bridgeReferenceAnnotation, ValueBridgeBuilderBeanReference bridgeBuilderReferenceAnnotation, PojoPropertyModel<?> annotationHolder) {
        Optional<BeanReference> bridgeReference = this.toBeanReference(bridgeReferenceAnnotation.name(), bridgeReferenceAnnotation.type(), ValueBridgeBeanReference.UndefinedImplementationType.class);
        Optional<BeanReference> bridgeBuilderReference = this.toBeanReference(bridgeBuilderReferenceAnnotation.name(), bridgeBuilderReferenceAnnotation.type(), ValueBridgeBuilderBeanReference.UndefinedImplementationType.class);
        if (bridgeReference.isPresent() && bridgeBuilderReference.isPresent()) {
            throw log.invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference(annotationHolder.getName());
        }
        if (bridgeReference.isPresent()) {
            BeanResolverBridgeBuilder<ValueBridge> castedBuilder = new BeanResolverBridgeBuilder<ValueBridge>(ValueBridge.class, bridgeReference.get());
            return castedBuilder;
        }
        if (bridgeBuilderReference.isPresent()) {
            return (BridgeBuilder)this.beanProvider.getBean(bridgeBuilderReference.get(), BridgeBuilder.class);
        }
        return null;
    }

    private <A extends Annotation, B> BridgeBuilder<B> createAnnotationMappedBridgeBuilder(Class<? extends Annotation> bridgeMappingAnnotation, Class<B> bridgeClass, A annotation, Optional<BeanReference> bridgeReferenceOptional, Optional<BeanReference> builderReferenceOptional) {
        if (bridgeReferenceOptional.isPresent() && builderReferenceOptional.isPresent()) {
            throw log.conflictingBridgeReferenceInBridgeMapping(bridgeMappingAnnotation, annotation.annotationType());
        }
        if (bridgeReferenceOptional.isPresent()) {
            return new BeanResolverBridgeBuilder<B>(bridgeClass, bridgeReferenceOptional.get());
        }
        if (builderReferenceOptional.isPresent()) {
            AnnotationBridgeBuilder builder = (AnnotationBridgeBuilder)this.beanProvider.getBean(builderReferenceOptional.get(), AnnotationBridgeBuilder.class);
            builder.initialize(annotation);
            return builder;
        }
        throw log.missingBridgeReferenceInBridgeMapping(bridgeMappingAnnotation, annotation.annotationType());
    }

    Optional<BeanReference> toBeanReference(String name, Class<?> type, Class<?> undefinedTypeMarker) {
        Class<?> cleanedUpType;
        String cleanedUpName = name.isEmpty() ? null : name;
        Class<?> clazz = cleanedUpType = undefinedTypeMarker.equals(type) ? null : type;
        if (cleanedUpName == null && cleanedUpType == null) {
            return Optional.empty();
        }
        return Optional.of(BeanReference.of((String)cleanedUpName, cleanedUpType));
    }
}

