/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.mapping.impl.CachingCastingEntitySupplier;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeWorkPlan;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.impl.common.ToStringTreeAppendable;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoContainedTypeManager<E>
implements AutoCloseable,
ToStringTreeAppendable {
    private final Class<E> javaClass;
    private final PojoCaster<E> caster;
    private final PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver;

    public PojoContainedTypeManager(Class<E> javaClass, PojoCaster<E> caster, PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver) {
        this.javaClass = javaClass;
        this.caster = caster;
        this.reindexingResolver = reindexingResolver;
    }

    @Override
    public void close() {
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("javaClass", this.javaClass).attribute("reindexingResolver", this.reindexingResolver);
    }

    Supplier<E> toEntitySupplier(AbstractPojoSessionContextImplementor sessionContext, Object entity) {
        PojoRuntimeIntrospector introspector = sessionContext.getRuntimeIntrospector();
        return new CachingCastingEntitySupplier<E>(this.caster, introspector, entity);
    }

    void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, Supplier<E> entitySupplier, Set<String> dirtyPaths) {
        this.reindexingResolver.resolveEntitiesToReindex(collector, runtimeIntrospector, entitySupplier.get(), dirtyPaths);
    }

    PojoContainedTypeWorkPlan<E> createWorkPlan(AbstractPojoSessionContextImplementor sessionContext) {
        return new PojoContainedTypeWorkPlan(this, sessionContext);
    }
}

