/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoSearchManagerDelegateImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchManagerDelegate;
import org.hibernate.search.util.impl.common.Closer;

public class PojoMappingDelegateImpl
implements PojoMappingDelegate {
    private final PojoIndexedTypeManagerContainer indexedTypeManagers;
    private final PojoContainedTypeManagerContainer containedTypeManagers;

    public PojoMappingDelegateImpl(PojoIndexedTypeManagerContainer indexedTypeManagers, PojoContainedTypeManagerContainer containedTypeManagers) {
        this.indexedTypeManagers = indexedTypeManagers;
        this.containedTypeManagers = containedTypeManagers;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(PojoIndexedTypeManager::close, this.indexedTypeManagers.getAll());
            closer.pushAll(PojoContainedTypeManager::close, this.containedTypeManagers.getAll());
        }
    }

    @Override
    public boolean isWorkable(Class<?> type) {
        return this.indexedTypeManagers.getByExactClass(type).isPresent() || this.containedTypeManagers.getByExactClass(type).isPresent();
    }

    @Override
    public boolean isIndexable(Class<?> type) {
        return this.indexedTypeManagers.getByExactClass(type).isPresent();
    }

    @Override
    public boolean isSearchable(Class<?> type) {
        return this.indexedTypeManagers.getAllBySuperClass(type).isPresent();
    }

    @Override
    public PojoSearchManagerDelegate createSearchManagerDelegate(AbstractPojoSessionContextImplementor sessionContextImplementor) {
        return new PojoSearchManagerDelegateImpl(this.indexedTypeManagers, this.containedTypeManagers, sessionContextImplementor);
    }
}

