/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchTarget;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchTargetBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoReferenceImpl;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchTargetDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.AssertionFailure;

class PojoSearchTargetDelegateImpl<E, O>
implements PojoSearchTargetDelegate<E, O> {
    private final PojoIndexedTypeManagerContainer typeManagers;
    private final Set<PojoIndexedTypeManager<?, ? extends E, ?>> targetedTypeManagers;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private MappedIndexSearchTarget<PojoReference, O> indexSearchTarget;

    PojoSearchTargetDelegateImpl(PojoIndexedTypeManagerContainer typeManagers, Set<PojoIndexedTypeManager<?, ? extends E, ?>> targetedTypeManagers, AbstractPojoSessionContextImplementor sessionContext) {
        this.typeManagers = typeManagers;
        this.targetedTypeManagers = targetedTypeManagers;
        this.sessionContext = sessionContext;
    }

    @Override
    public Set<Class<? extends E>> getTargetedIndexedTypes() {
        return this.targetedTypeManagers.stream().map(PojoIndexedTypeManager::getIndexedJavaClass).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsLoadedObject(ObjectLoader<PojoReference, T> objectLoader, Function<SearchQuery<T>, Q> searchQueryWrapperFactory) {
        return this.getIndexSearchTarget().queryAsLoadedObject((SessionContextImplementor)this.sessionContext, objectLoader, searchQueryWrapperFactory);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsReference(Function<SearchQuery<PojoReference>, Q> searchQueryWrapperFactory) {
        return this.getIndexSearchTarget().queryAsReference((SessionContextImplementor)this.sessionContext, searchQueryWrapperFactory);
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsProjection(ObjectLoader<PojoReference, O> objectLoader, Function<SearchQuery<T>, Q> searchQueryWrapperFactory, SearchProjection<T> projection) {
        return this.getIndexSearchTarget().queryAsProjection((SessionContextImplementor)this.sessionContext, objectLoader, searchQueryWrapperFactory, projection);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsProjections(ObjectLoader<PojoReference, O> objectLoader, Function<SearchQuery<List<?>>, Q> searchQueryWrapperFactory, SearchProjection<?> ... projections) {
        return this.getIndexSearchTarget().queryAsProjections((SessionContextImplementor)this.sessionContext, objectLoader, searchQueryWrapperFactory, projections);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return this.getIndexSearchTarget().predicate();
    }

    @Override
    public SearchSortContainerContext sort() {
        return this.getIndexSearchTarget().sort();
    }

    @Override
    public SearchProjectionFactoryContext<PojoReference, O> projection() {
        return this.getIndexSearchTarget().projection();
    }

    private MappedIndexSearchTarget<PojoReference, O> getIndexSearchTarget() {
        AbstractPojoMappingContextImplementor mappingContext = this.sessionContext.getMappingContext();
        if (this.indexSearchTarget == null) {
            Iterator<PojoIndexedTypeManager<?, E, ?>> iterator = this.targetedTypeManagers.iterator();
            MappedIndexSearchTargetBuilder builder = iterator.next().createSearchTargetBuilder(mappingContext, this::toPojoReference);
            while (iterator.hasNext()) {
                iterator.next().addToSearchTarget(builder);
            }
            this.indexSearchTarget = builder.build();
        }
        return this.indexSearchTarget;
    }

    private PojoReference toPojoReference(DocumentReference documentReference) {
        PojoIndexedTypeManager<?, ?, ?> typeManager = this.typeManagers.getByIndexName(documentReference.getIndexName()).orElseThrow(() -> new AssertionFailure("Document reference " + documentReference + " could not be converted to a PojoReference"));
        Object id = typeManager.getIdentifierMapping().fromDocumentIdentifier(documentReference.getId(), this.sessionContext);
        return new PojoReferenceImpl(typeManager.getIndexedJavaClass(), id);
    }
}

