/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeWorkPlan;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeWorkPlan;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeWorkPlan;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.LoggerFactory;

class PojoWorkPlanImpl
implements PojoWorkPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexedTypeManagerContainer indexedTypeManagers;
    private final PojoContainedTypeManagerContainer containedTypeManagers;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final Map<Class<?>, PojoIndexedTypeWorkPlan<?, ?, ?>> indexedTypeDelegates = new LinkedHashMap();
    private final Map<Class<?>, PojoContainedTypeWorkPlan<?>> containedTypeDelegates = new HashMap();

    PojoWorkPlanImpl(PojoIndexedTypeManagerContainer indexedTypeManagers, PojoContainedTypeManagerContainer containedTypeManagers, AbstractPojoSessionContextImplementor sessionContext) {
        this.indexedTypeManagers = indexedTypeManagers;
        this.containedTypeManagers = containedTypeManagers;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.getRuntimeIntrospector();
    }

    @Override
    public void add(Object entity) {
        this.add(null, entity);
    }

    @Override
    public void add(Object id, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.add(id, entity);
    }

    @Override
    public void update(Object entity) {
        this.update(null, entity);
    }

    @Override
    public void update(Object id, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.update(id, entity);
    }

    @Override
    public void update(Object entity, String ... dirtyPaths) {
        this.update(null, entity, dirtyPaths);
    }

    @Override
    public void update(Object id, Object entity, String ... dirtyPaths) {
        Class<Object> clazz = this.getIntrospector().getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.update(id, entity, dirtyPaths);
    }

    @Override
    public void delete(Object entity) {
        this.delete(null, entity);
    }

    @Override
    public void delete(Object id, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.delete(id, entity);
    }

    @Override
    public void prepare() {
        for (PojoContainedTypeWorkPlan<?> pojoContainedTypeWorkPlan : this.containedTypeDelegates.values()) {
            pojoContainedTypeWorkPlan.resolveDirty(this::updateBecauseOfContained);
        }
        for (PojoIndexedTypeWorkPlan pojoIndexedTypeWorkPlan : this.indexedTypeDelegates.values()) {
            pojoIndexedTypeWorkPlan.resolveDirty(this::updateBecauseOfContained);
        }
        for (PojoIndexedTypeWorkPlan pojoIndexedTypeWorkPlan : this.indexedTypeDelegates.values()) {
            pojoIndexedTypeWorkPlan.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> execute() {
        try {
            this.prepare();
            ArrayList futures = new ArrayList();
            for (PojoIndexedTypeWorkPlan<?, ?, ?> delegate : this.indexedTypeDelegates.values()) {
                futures.add(delegate.execute());
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    private PojoRuntimeIntrospector getIntrospector() {
        return this.introspector;
    }

    private AbstractPojoTypeWorkPlan getDelegate(Class<?> clazz) {
        AbstractPojoTypeWorkPlan delegate = this.indexedTypeDelegates.get(clazz);
        if (delegate == null && (delegate = (AbstractPojoTypeWorkPlan)this.containedTypeDelegates.get(clazz)) == null) {
            delegate = this.createDelegate(clazz);
        }
        return delegate;
    }

    private AbstractPojoTypeWorkPlan createDelegate(Class<?> clazz) {
        Optional<PojoIndexedTypeManager<?, ?, ?>> indexedTypeManagerOptional = this.indexedTypeManagers.getByExactClass(clazz);
        if (indexedTypeManagerOptional.isPresent()) {
            PojoIndexedTypeWorkPlan<?, ?, ?> delegate = indexedTypeManagerOptional.get().createWorkPlan(this.sessionContext);
            this.indexedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        Optional<PojoContainedTypeManager<?>> containedTypeManagerOptional = this.containedTypeManagers.getByExactClass(clazz);
        if (containedTypeManagerOptional.isPresent()) {
            PojoContainedTypeWorkPlan<?> delegate = containedTypeManagerOptional.get().createWorkPlan(this.sessionContext);
            this.containedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        throw log.notIndexedTypeNorAsDelegate(clazz);
    }

    private PojoIndexedTypeWorkPlan<?, ?, ?> getOrCreateIndexedDelegateForContainedUpdate(Class<?> clazz) {
        PojoIndexedTypeWorkPlan<?, ?, ?> delegate = this.indexedTypeDelegates.get(clazz);
        if (delegate != null) {
            return delegate;
        }
        Optional<PojoIndexedTypeManager<?, ?, ?>> indexedTypeManagerOptional = this.indexedTypeManagers.getByExactClass(clazz);
        if (indexedTypeManagerOptional.isPresent()) {
            delegate = indexedTypeManagerOptional.get().createWorkPlan(this.sessionContext);
            this.indexedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        throw new AssertionFailure("Attempt to reindex an entity of type " + clazz + " because a contained entity was modified, but " + clazz + " is not indexed directly. This is proa");
    }

    private void updateBecauseOfContained(Object containingEntity) {
        Class<Object> clazz = this.getIntrospector().getClass(containingEntity);
        PojoIndexedTypeWorkPlan<?, ?, ?> delegate = this.getOrCreateIndexedDelegateForContainedUpdate(clazz);
        delegate.updateBecauseOfContained(containingEntity);
    }
}

