/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;
import org.hibernate.search.mapper.pojo.mapping.impl.IdentifierMapping;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;

public class PropertyIdentifierMapping<I, E>
implements IdentifierMapping<I, E> {
    private final PojoCaster<? super I> caster;
    private final PropertyHandle property;
    private final IdentifierBridge<I> bridge;

    public PropertyIdentifierMapping(PojoCaster<? super I> caster, PropertyHandle property, IdentifierBridge<I> bridge) {
        this.caster = caster;
        this.property = property;
        this.bridge = bridge;
    }

    @Override
    public void close() {
        this.bridge.close();
    }

    @Override
    public I getIdentifier(Object providedId, Supplier<? extends E> entitySupplier) {
        if (providedId != null) {
            return this.caster.cast(providedId);
        }
        Object id = this.property.get(entitySupplier.get());
        return this.caster.cast(id);
    }

    @Override
    public String toDocumentIdentifier(I identifier, AbstractPojoMappingContextImplementor context) {
        return this.bridge.toDocumentIdentifier(identifier, context.getIdentifierBridgeToDocumentIdentifierContext());
    }

    @Override
    public I fromDocumentIdentifier(String documentId, AbstractPojoSessionContextImplementor context) {
        return this.bridge.fromDocumentIdentifier(documentId, context.getIdentifierBridgeFromDocumentIdentifierContext());
    }
}

