/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.util.impl.common.Closer;

public abstract class AbstractPojoMappingImplementor<M>
implements MappingImplementor<M> {
    private final PojoMappingDelegate delegate;
    private final List<CloseDelegate> closeDelegates = new ArrayList<CloseDelegate>();
    private boolean closed = false;

    public AbstractPojoMappingImplementor(PojoMappingDelegate delegate) {
        this.delegate = delegate;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try (Closer closer = new Closer();){
                closer.push(PojoMappingDelegate::close, (Object)this.delegate);
                closer.pushAll(CloseDelegate::close, this.closeDelegates);
            }
        }
    }

    protected final PojoMappingDelegate getDelegate() {
        return this.delegate;
    }

    public void onClose(CloseDelegate closeable) {
        this.closeDelegates.add(closeable);
    }

    public static interface CloseDelegate
    extends AutoCloseable {
        @Override
        public void close();
    }
}

