/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.logging.spi.ContextualFailureCollector;
import org.hibernate.search.mapper.pojo.bridge.mapping.MarkerBuilder;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.logging.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoValueAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoValueAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;

class PojoPropertyAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorPropertyNode {
    private final PojoTypeAdditionalMetadataBuilder rootBuilder;
    private final String propertyName;
    private final Map<ContainerValueExtractorPath, PojoValueAdditionalMetadataBuilder> valueBuilders = new LinkedHashMap<ContainerValueExtractorPath, PojoValueAdditionalMetadataBuilder>();
    private final Map<Class<?>, List<?>> markers = new LinkedHashMap();

    PojoPropertyAdditionalMetadataBuilder(PojoTypeAdditionalMetadataBuilder rootBuilder, String propertyName) {
        this.rootBuilder = rootBuilder;
        this.propertyName = propertyName;
    }

    @Override
    public ContextualFailureCollector getFailureCollector() {
        return this.rootBuilder.getFailureCollector().withContext(PojoEventContexts.fromPath(PojoModelPath.fromRoot(this.propertyName)));
    }

    @Override
    public PojoAdditionalMetadataCollectorValueNode value(ContainerValueExtractorPath extractorPath) {
        return this.valueBuilders.computeIfAbsent(extractorPath, path -> new PojoValueAdditionalMetadataBuilder(this.rootBuilder, this.propertyName, extractorPath));
    }

    @Override
    public final void marker(MarkerBuilder builder) {
        this.doAddMarker(builder.build());
    }

    private <M> void doAddMarker(M marker) {
        Class<Object> markerType = marker instanceof Annotation ? ((Annotation)marker).annotationType() : marker.getClass();
        List list = this.markers.computeIfAbsent(markerType, ignored -> new ArrayList());
        list.add(marker);
    }

    PojoPropertyAdditionalMetadata build() {
        HashMap<ContainerValueExtractorPath, PojoValueAdditionalMetadata> values = new HashMap<ContainerValueExtractorPath, PojoValueAdditionalMetadata>();
        for (Map.Entry<ContainerValueExtractorPath, PojoValueAdditionalMetadataBuilder> entry : this.valueBuilders.entrySet()) {
            values.put(entry.getKey(), entry.getValue().build());
        }
        return new PojoPropertyAdditionalMetadata(values, this.markers);
    }
}

