/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.logging.spi.FailureCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public class PojoTypeAdditionalMetadataProvider {
    private final FailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> modelContributorProvider;
    private final Map<PojoRawTypeModel<?>, PojoTypeAdditionalMetadata> cache = new HashMap();

    public PojoTypeAdditionalMetadataProvider(FailureCollector failureCollector, TypeMetadataContributorProvider<PojoTypeMetadataContributor> modelContributorProvider) {
        this.failureCollector = failureCollector;
        this.modelContributorProvider = modelContributorProvider;
    }

    public PojoTypeAdditionalMetadata get(PojoRawTypeModel<?> typeModel) {
        return this.cache.computeIfAbsent(typeModel, this::createTypeAdditionalMetadata);
    }

    private PojoTypeAdditionalMetadata createTypeAdditionalMetadata(PojoRawTypeModel<?> typeModel) {
        PojoTypeAdditionalMetadataBuilder builder = new PojoTypeAdditionalMetadataBuilder(this.failureCollector, typeModel);
        this.modelContributorProvider.forEach(typeModel, c -> c.contributeModel(builder));
        return builder.build();
    }
}

