/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.Collection;
import java.util.Optional;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexModelBindingContext;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorContainerElementNode;

class PojoIndexingProcessorContainerElementNodeBuilder<P extends C, C, V>
extends AbstractPojoProcessorNodeBuilder {
    private final BoundPojoModelPathValueNode<?, P, V> modelPath;
    private final ContainerValueExtractor<C, V> extractor;
    private final PojoIndexingProcessorValueNodeBuilderDelegate<P, V> valueNodeProcessorCollectionBuilder;

    PojoIndexingProcessorContainerElementNodeBuilder(BoundPojoModelPathValueNode<?, P, V> modelPath, ContainerValueExtractor<C, V> extractor, PojoMappingHelper mappingHelper, IndexModelBindingContext bindingContext) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.extractor = extractor;
        this.valueNodeProcessorCollectionBuilder = new PojoIndexingProcessorValueNodeBuilderDelegate<P, V>(modelPath, mappingHelper, bindingContext);
    }

    public PojoMappingCollectorValueNode value() {
        return this.valueNodeProcessorCollectionBuilder;
    }

    @Override
    BoundPojoModelPathValueNode<?, ? extends C, V> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        this.valueNodeProcessorCollectionBuilder.closeOnFailure();
    }

    Optional<PojoIndexingProcessorContainerElementNode<C, V>> build(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        try {
            return this.doBuild(parentDependencyCollector);
        }
        catch (RuntimeException e) {
            this.getFailureCollector().add((Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<PojoIndexingProcessorContainerElementNode<C, V>> doBuild(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        Collection immutableNestedProcessors = this.valueNodeProcessorCollectionBuilder.build(parentDependencyCollector);
        if (immutableNestedProcessors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PojoIndexingProcessorContainerElementNode(this.extractor, immutableNestedProcessors));
    }
}

