/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexModelBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundPropertyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorContainerElementNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorPropertyNode;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.SuppressingCloser;

class PojoIndexingProcessorPropertyNodeBuilder<T, P>
extends AbstractPojoProcessorNodeBuilder
implements PojoMappingCollectorPropertyNode {
    private final BoundPojoModelPathPropertyNode<T, P> modelPath;
    private final Optional<PojoIdentityMappingCollector> identityMappingCollector;
    private final Collection<BoundPropertyBridge<P>> boundPropertyBridges = new ArrayList<BoundPropertyBridge<P>>();
    private final PojoIndexingProcessorValueNodeBuilderDelegate<P, P> valueWithoutExtractorBuilderDelegate;
    private Map<ContainerValueExtractorPath, PojoIndexingProcessorContainerElementNodeBuilder<P, ? super P, ?>> containerElementNodeBuilders = new LinkedHashMap();

    PojoIndexingProcessorPropertyNodeBuilder(BoundPojoModelPathPropertyNode<T, P> modelPath, PojoMappingHelper mappingHelper, IndexModelBindingContext bindingContext, Optional<PojoIdentityMappingCollector> identityMappingCollector) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.identityMappingCollector = identityMappingCollector;
        this.valueWithoutExtractorBuilderDelegate = new PojoIndexingProcessorValueNodeBuilderDelegate<P, P>(modelPath.valueWithoutExtractors(), mappingHelper, bindingContext);
    }

    @Override
    public void bridge(BridgeBuilder<? extends PropertyBridge> builder) {
        this.mappingHelper.getIndexModelBinder().addPropertyBridge(this.bindingContext, this.modelPath, builder).ifPresent(this.boundPropertyBridges::add);
    }

    @Override
    public void identifierBridge(BridgeBuilder<? extends IdentifierBridge<?>> builder) {
        if (this.identityMappingCollector.isPresent()) {
            IdentifierBridge<P> bridge = this.mappingHelper.getIndexModelBinder().addIdentifierBridge(this.modelPath, builder);
            this.identityMappingCollector.get().identifierBridge(this.modelPath, bridge);
        }
    }

    @Override
    public PojoMappingCollectorValueNode value(ContainerValueExtractorPath extractorPath) {
        if (!extractorPath.isEmpty()) {
            PojoIndexingProcessorContainerElementNodeBuilder<P, P, ?> containerElementNodeBuilder = this.containerElementNodeBuilders.get(extractorPath);
            if (containerElementNodeBuilder == null && !this.containerElementNodeBuilders.containsKey(extractorPath)) {
                BoundContainerValueExtractorPath<P, ?> boundExtractorPath = this.mappingHelper.getIndexModelBinder().bindExtractorPath(this.modelPath.getPropertyModel().getTypeModel(), extractorPath);
                ContainerValueExtractorPath explicitExtractorPath = boundExtractorPath.getExtractorPath();
                if (!explicitExtractorPath.isEmpty() && (containerElementNodeBuilder = this.containerElementNodeBuilders.get(explicitExtractorPath)) == null) {
                    containerElementNodeBuilder = this.createContainerElementNodeBuilder(boundExtractorPath);
                }
                this.containerElementNodeBuilders.put(explicitExtractorPath, containerElementNodeBuilder);
                this.containerElementNodeBuilders.put(extractorPath, containerElementNodeBuilder);
            }
            if (containerElementNodeBuilder != null) {
                return containerElementNodeBuilder.value();
            }
        }
        return this.valueWithoutExtractorBuilderDelegate;
    }

    private <V> PojoIndexingProcessorContainerElementNodeBuilder<P, ? super P, V> createContainerElementNodeBuilder(BoundContainerValueExtractorPath<P, V> boundExtractorPath) {
        ContainerValueExtractor<P, V> extractor = this.mappingHelper.getIndexModelBinder().createExtractors(boundExtractorPath);
        BoundPojoModelPathValueNode<T, P, V> containerElementPath = this.modelPath.value(boundExtractorPath);
        return new PojoIndexingProcessorContainerElementNodeBuilder<P, P, V>(containerElementPath, extractor, this.mappingHelper, this.bindingContext);
    }

    @Override
    BoundPojoModelPath getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(boundBridge -> boundBridge.getBridge().close(), this.boundPropertyBridges);
            closer.push(PojoIndexingProcessorValueNodeBuilderDelegate::closeOnFailure, this.valueWithoutExtractorBuilderDelegate);
            closer.pushAll(PojoIndexingProcessorContainerElementNodeBuilder::closeOnFailure, this.containerElementNodeBuilders.values());
        }
    }

    Optional<PojoIndexingProcessorPropertyNode<T, P>> build(PojoIndexingDependencyCollectorTypeNode<T> parentDependencyCollector) {
        try {
            return this.doBuild(parentDependencyCollector);
        }
        catch (RuntimeException e) {
            this.getFailureCollector().add((Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<PojoIndexingProcessorPropertyNode<T, P>> doBuild(PojoIndexingDependencyCollectorTypeNode<T> parentDependencyCollector) {
        PojoIndexingDependencyCollectorPropertyNode propertyDependencyCollector = parentDependencyCollector.property(this.modelPath.getPropertyHandle());
        List immutableNestedNodes = Collections.emptyList();
        try {
            ArrayList<PropertyBridge> immutableBridges = this.boundPropertyBridges.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyBridge>();
            for (BoundPropertyBridge<P> boundBridge : this.boundPropertyBridges) {
                immutableBridges.add(boundBridge.getBridge());
                boundBridge.getPojoModelRootElement().contributeDependencies(propertyDependencyCollector);
            }
            Collection<PojoIndexingProcessor<P>> valueWithoutExtractorNodes = this.valueWithoutExtractorBuilderDelegate.build(propertyDependencyCollector);
            if (!valueWithoutExtractorNodes.isEmpty() || !this.containerElementNodeBuilders.isEmpty()) {
                immutableNestedNodes = new ArrayList(valueWithoutExtractorNodes.size() + this.containerElementNodeBuilders.size());
            }
            if (!valueWithoutExtractorNodes.isEmpty()) {
                immutableNestedNodes.addAll(valueWithoutExtractorNodes);
            }
            this.containerElementNodeBuilders.values().stream().distinct().filter(Objects::nonNull).map(builder -> builder.build(propertyDependencyCollector)).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
            if (immutableBridges.isEmpty() && immutableNestedNodes.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new PojoIndexingProcessorPropertyNode(this.modelPath.getPropertyHandle(), immutableBridges, immutableNestedNodes));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(PojoIndexingProcessor::close, immutableNestedNodes);
            throw e;
        }
    }
}

