/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import java.util.Collection;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.model.impl.PojoElementImpl;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoIndexingProcessorPropertyNode<T, P>
extends PojoIndexingProcessor<T> {
    private final PropertyHandle handle;
    private final Collection<PropertyBridge> propertyBridges;
    private final Collection<PojoIndexingProcessor<? super P>> nestedNodes;

    public PojoIndexingProcessorPropertyNode(PropertyHandle handle, Collection<PropertyBridge> propertyBridges, Collection<PojoIndexingProcessor<? super P>> nestedNodes) {
        this.handle = handle;
        this.propertyBridges = propertyBridges;
        this.nestedNodes = nestedNodes;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(PropertyBridge::close, this.propertyBridges);
            closer.pushAll(PojoIndexingProcessor::close, this.nestedNodes);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("handle", (Object)this.handle);
        builder.startList("bridges");
        for (PropertyBridge propertyBridge : this.propertyBridges) {
            builder.value((Object)propertyBridge);
        }
        builder.endList();
        builder.startList("nestedNodes");
        for (PojoIndexingProcessor pojoIndexingProcessor : this.nestedNodes) {
            builder.value((Object)pojoIndexingProcessor);
        }
        builder.endList();
    }

    @Override
    public final void process(DocumentElement target, T source, AbstractPojoSessionContextImplementor sessionContext) {
        Object propertyValue = this.handle.get(source);
        if (!this.propertyBridges.isEmpty()) {
            PojoElementImpl bridgedElement = new PojoElementImpl(propertyValue);
            for (PropertyBridge bridge : this.propertyBridges) {
                bridge.write(target, bridgedElement, sessionContext.getPropertyBridgeWriteContext());
            }
        }
        for (PojoIndexingProcessor<P> nestedNode : this.nestedNodes) {
            nestedNode.process(target, propertyValue, sessionContext);
        }
    }
}

