/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoIndexingProcessorValueBridgeNode<V, F>
extends PojoIndexingProcessor<V> {
    private final ValueBridge<? super V, F> bridge;
    private final IndexFieldAccessor<? super F> indexFieldAccessor;

    public PojoIndexingProcessorValueBridgeNode(ValueBridge<? super V, F> bridge, IndexFieldAccessor<? super F> indexFieldAccessor) {
        this.bridge = bridge;
        this.indexFieldAccessor = indexFieldAccessor;
    }

    @Override
    public void close() {
        this.bridge.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("bridge", this.bridge);
        builder.attribute("indexFieldAccessor", this.indexFieldAccessor);
    }

    @Override
    public void process(DocumentElement target, V source, AbstractPojoSessionContextImplementor sessionContext) {
        F indexFieldValue = this.bridge.toIndexedValue(source, sessionContext.getMappingContext().getToIndexedValueContext());
        this.indexFieldAccessor.write(target, indexFieldValue);
    }
}

