/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.impl;

import java.lang.annotation.Annotation;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.mapping.AnnotationMarkerBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.MarkerBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.MarkerBuilder;

public final class AnnotationInitializingBeanDelegatingMarkerBuilder<A extends Annotation>
implements MarkerBuilder {
    private final BeanReference<? extends AnnotationMarkerBuilder> delegateReference;
    private final A annotation;

    public AnnotationInitializingBeanDelegatingMarkerBuilder(BeanReference<? extends AnnotationMarkerBuilder> delegateReference, A annotation) {
        this.delegateReference = delegateReference;
        this.annotation = annotation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + ", annotation=" + this.annotation + "]";
    }

    @Override
    public Object build(MarkerBuildContext buildContext) {
        try (BeanHolder delegateHolder = this.delegateReference.getBean(buildContext.getBeanProvider());){
            ((AnnotationMarkerBuilder)delegateHolder.get()).initialize(this.annotation);
            Object object = ((AnnotationMarkerBuilder)delegateHolder.get()).build(buildContext);
            return object;
        }
    }
}

