/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoImplicitReindexingResolverNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverMarkingNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.util.impl.common.Closer;

abstract class AbstractPojoImplicitReindexingResolverTypeNodeBuilder<T, U>
extends AbstractPojoImplicitReindexingResolverNodeBuilder<T> {
    private final BoundPojoModelPathTypeNode<U> modelPath;
    private final PojoImplicitReindexingResolverMarkingNodeBuilder<U> markingNodeBuilder;
    private final Map<String, PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?>> propertyNodeBuilders = new LinkedHashMap();

    AbstractPojoImplicitReindexingResolverTypeNodeBuilder(BoundPojoModelPathTypeNode<U> modelPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.modelPath = modelPath;
        this.markingNodeBuilder = new PojoImplicitReindexingResolverMarkingNodeBuilder<U>(modelPath, buildingHelper);
    }

    @Override
    BoundPojoModelPathTypeNode<U> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(PojoImplicitReindexingResolverMarkingNodeBuilder::closeOnFailure, this.markingNodeBuilder);
            closer.pushAll(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.propertyNodeBuilders.values());
        }
    }

    PojoTypeModel<U> getTypeModel() {
        return this.modelPath.getTypeModel();
    }

    PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> property(String propertyName) {
        return this.getOrCreatePropertyBuilder(propertyName);
    }

    void addDirtyPathTriggeringReindexing(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.checkNotFrozen();
        this.markingNodeBuilder.addDirtyPathTriggeringReindexing(dirtyPathFromEntityType);
    }

    @Override
    void onFreeze(Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingCollector) {
        this.markingNodeBuilder.freeze();
        dirtyPathsTriggeringReindexingCollector.addAll(this.markingNodeBuilder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        for (PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> builder : this.propertyNodeBuilders.values()) {
            builder.freeze();
            dirtyPathsTriggeringReindexingCollector.addAll(builder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        }
    }

    @Override
    final <S> Optional<PojoImplicitReindexingResolverNode<T, S>> doBuild(PojoPathFilterFactory<S> pathFilterFactory, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        this.checkFrozen();
        ArrayList<PojoImplicitReindexingResolverNode<U, S>> immutableNestedNodes = new ArrayList<PojoImplicitReindexingResolverNode<U, S>>();
        this.markingNodeBuilder.build(pathFilterFactory, allPotentialDirtyPaths).ifPresent(immutableNestedNodes::add);
        this.propertyNodeBuilders.values().stream().map(builder -> builder.build(pathFilterFactory, allPotentialDirtyPaths)).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
        if (immutableNestedNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.doBuild(immutableNestedNodes));
    }

    abstract <S> PojoImplicitReindexingResolverNode<T, S> doBuild(Collection<PojoImplicitReindexingResolverNode<? super U, S>> var1);

    private PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> getOrCreatePropertyBuilder(String propertyName) {
        return this.propertyNodeBuilders.computeIfAbsent(propertyName, this::createPropertyBuilder);
    }

    private PojoImplicitReindexingResolverPropertyNodeBuilder<U, ?> createPropertyBuilder(String propertyName) {
        this.checkNotFrozen();
        PropertyHandle handle = this.modelPath.getTypeModel().getProperty(propertyName).getHandle();
        return new PojoImplicitReindexingResolverPropertyNodeBuilder(this.modelPath.property(handle), this.buildingHelper);
    }
}

