/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.impl.DefaultPojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.AssertionFailure;

class PojoImplicitReindexingResolverBuilder<T> {
    private final PojoRawTypeModel<T> rawTypeModel;
    private Set<PojoModelPathValueNode> dirtyPathsTriggeringSelfReindexing = new LinkedHashSet<PojoModelPathValueNode>();
    private final PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRootBuilder;
    private boolean frozen = false;

    PojoImplicitReindexingResolverBuilder(PojoRawTypeModel<T> rawTypeModel, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.rawTypeModel = rawTypeModel;
        this.containingEntitiesResolverRootBuilder = new PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T>(BoundPojoModelPath.root(rawTypeModel), buildingHelper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.rawTypeModel + "]";
    }

    void closeOnFailure() {
        this.containingEntitiesResolverRootBuilder.closeOnFailure();
    }

    void addDirtyPathTriggeringSelfReindexing(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.checkNotFrozen();
        this.dirtyPathsTriggeringSelfReindexing.add(dirtyPathFromEntityType.toUnboundPath());
    }

    PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRoot() {
        return this.containingEntitiesResolverRootBuilder;
    }

    final <S> Optional<PojoImplicitReindexingResolver<T, S>> build(PojoPathFilterFactory<S> pathFilterFactory) {
        this.freeze();
        Set<PojoModelPathValueNode> immutableDirtyPathsAcceptedByFilter = this.dirtyPathsTriggeringSelfReindexing;
        Optional<PojoImplicitReindexingResolverNode<PojoImplicitReindexingResolverNode, S>> containingEntitiesResolverRootOptional = this.containingEntitiesResolverRootBuilder.build(pathFilterFactory, null);
        if (immutableDirtyPathsAcceptedByFilter.isEmpty() && !containingEntitiesResolverRootOptional.isPresent()) {
            return Optional.empty();
        }
        PojoPathFilter filter = immutableDirtyPathsAcceptedByFilter.isEmpty() ? PojoPathFilter.empty() : pathFilterFactory.create(immutableDirtyPathsAcceptedByFilter);
        PojoImplicitReindexingResolverNode containingEntitiesResolverRoot = containingEntitiesResolverRootOptional.orElseGet(PojoImplicitReindexingResolverNode::noOp);
        return Optional.of(new DefaultPojoImplicitReindexingResolver(filter, containingEntitiesResolverRoot));
    }

    private void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.containingEntitiesResolverRootBuilder.freeze();
        }
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + this + " after it was frozen. There is a bug in Hibernate Search, please report it.");
        }
    }
}

