/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.mapper.pojo.dirtiness.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class PojoIndexingDependencyCollectorValueNode<P, V>
extends AbstractPojoIndexingDependencyCollectorNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode;
    private final BoundPojoModelPathValueNode<?, P, V> modelPathFromLastTypeNode;
    private final PojoModelPathValueNode unboundModelPathFromLastTypeNode;
    private final PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode;
    private final BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode;
    private final BoundPojoModelPathValueNode<?, P, V> modelPathFromRootEntityNode;
    private final ReindexOnUpdate reindexOnUpdate;
    private final Set<PojoModelPathValueNode> derivedFrom;
    private Map<PojoRawTypeModel<?>, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> inverseAssociationPathCache = new HashMap();

    PojoIndexingDependencyCollectorValueNode(PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastTypeNode, PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromRootEntityNode, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        this.modelPathFromLastTypeNode = modelPathFromLastTypeNode;
        this.unboundModelPathFromLastTypeNode = modelPathFromLastTypeNode.toUnboundPath();
        this.lastEntityNode = lastEntityNode;
        this.modelPathFromLastEntityNode = modelPathFromLastEntityNode;
        this.modelPathFromRootEntityNode = modelPathFromRootEntityNode;
        BoundPojoModelPathValueNode<?, P, V> modelPathValueNode = modelPathFromLastTypeNode;
        BoundPojoModelPath modelPathPropertyNode = modelPathValueNode.getParent();
        BoundPojoModelPath modelPathTypeNode = ((BoundPojoModelPathPropertyNode)modelPathPropertyNode).getParent();
        this.reindexOnUpdate = buildingHelper.getReindexOnUpdate(parentNode.getReindexOnUpdate(), ((BoundPojoModelPathTypeNode)modelPathTypeNode).getTypeModel(), ((BoundPojoModelPathPropertyNode)modelPathPropertyNode).getPropertyModel().getName(), modelPathValueNode.getExtractorPath());
        this.derivedFrom = buildingHelper.getDerivedFrom(((BoundPojoModelPathTypeNode)modelPathTypeNode).getTypeModel(), ((BoundPojoModelPathPropertyNode)modelPathPropertyNode).getPropertyModel().getName(), modelPathValueNode.getExtractorPath());
    }

    public PojoIndexingDependencyCollectorTypeNode<V> type() {
        return new PojoIndexingDependencyCollectorTypeNode<V>(this, this.lastEntityNode, this.modelPathFromLastEntityNode.type(), this.modelPathFromRootEntityNode.type(), this.buildingHelper);
    }

    public void collectDependency() {
        this.doCollectDependency(null);
    }

    private void doCollectDependency(PojoIndexingDependencyCollectorValueNode<?, ?> initialNodeCollectingDependency) {
        if (initialNodeCollectingDependency != null) {
            if (initialNodeCollectingDependency.unboundModelPathFromLastTypeNode.equals(this.unboundModelPathFromLastTypeNode)) {
                throw log.infiniteRecursionForDerivedFrom(this.modelPathFromLastTypeNode.getRootType().getRawType(), this.modelPathFromLastTypeNode.toUnboundPath());
            }
        } else {
            initialNodeCollectingDependency = this;
        }
        if (ReindexOnUpdate.DEFAULT.equals((Object)this.reindexOnUpdate)) {
            if (this.derivedFrom.isEmpty()) {
                this.lastEntityNode.collectDependency(this.modelPathFromLastEntityNode);
            } else {
                PojoIndexingDependencyCollectorTypeNode<?> lastTypeNode = this.parentNode.getParentNode();
                for (PojoModelPathValueNode path : this.derivedFrom) {
                    super.doCollectDependency(initialNodeCollectingDependency);
                }
            }
        }
    }

    @Override
    ReindexOnUpdate getReindexOnUpdate() {
        return this.reindexOnUpdate;
    }

    void markForReindexing(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseSideEntityTypeNodeBuilder, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        PojoTypeModel<V> expectedInverseSideEntityType;
        PojoRawTypeModel<V> expectedInverseSideEntityRawType;
        PojoTypeModel<?> inverseSideEntityType = inverseSideEntityTypeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.getRawType();
        if (!inverseSideRawEntityType.isSubTypeOf(expectedInverseSideEntityRawType = (expectedInverseSideEntityType = this.modelPathFromRootEntityNode.type().getTypeModel()).getRawType())) {
            throw new AssertionFailure("Error while building the automatic reindexing resolver at path " + this.modelPathFromRootEntityNode + ": the dependency collector was passed a resolver builder with incorrect type;  got " + inverseSideRawEntityType + ", but a subtype of " + expectedInverseSideEntityRawType + " was expected. This is very probably a bug in Hibernate Search, please report it.");
        }
        Map<PojoRawTypeModel<?>, PojoModelPathValueNode> inverseAssociationsPaths = this.getInverseAssociationPathByConcreteEntityType(inverseSideEntityTypeNodeBuilder.getTypeModel());
        for (Map.Entry<PojoRawTypeModel<?>, PojoModelPathValueNode> entry : inverseAssociationsPaths.entrySet()) {
            this.markForReindexingWithOriginalSideConcreteType((PojoTypeModel)entry.getKey(), inverseSideEntityTypeNodeBuilder, entry.getValue(), dependencyPathFromInverseSideEntityTypeNode);
        }
    }

    private Map<PojoRawTypeModel<?>, PojoModelPathValueNode> getInverseAssociationPathByConcreteEntityType(PojoTypeModel<?> inverseSideEntityType) {
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.getRawType();
        Map<PojoRawTypeModel<Object>, PojoModelPathValueNode> result = this.inverseAssociationPathCache.get(inverseSideRawEntityType);
        if (result == null) {
            if (!this.inverseAssociationPathCache.containsKey(inverseSideRawEntityType)) {
                PojoTypeModel<?> originalSideEntityType = this.lastEntityNode.getTypeModel();
                PojoRawTypeModel<?> originalSideRawEntityType = originalSideEntityType.getRawType();
                result = new LinkedHashMap();
                for (PojoRawTypeModel<?> concreteEntityType : this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(originalSideRawEntityType)) {
                    BoundPojoModelPathValueNode<?, ?, ?> modelPathFromConcreteEntitySubType = this.applyProcessingPathToSubType(concreteEntityType, this.modelPathFromLastEntityNode);
                    PojoModelPathValueNode inverseAssociationPath = this.buildingHelper.getPathInverter().invertPath(inverseSideEntityType, modelPathFromConcreteEntitySubType).orElse(null);
                    if (inverseAssociationPath == null) {
                        throw log.cannotInvertAssociation(inverseSideRawEntityType, concreteEntityType, this.modelPathFromLastEntityNode.toUnboundPath());
                    }
                    result.put(concreteEntityType, inverseAssociationPath);
                }
                this.inverseAssociationPathCache.put(inverseSideRawEntityType, result);
            } else {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    private void markForReindexingWithOriginalSideConcreteType(PojoTypeModel<?> originalSideConcreteEntityType, AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> typeNodeBuilder, PojoModelPathValueNode inverseAssociationPath, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        Set<PojoRawTypeModel<?>> valueNodeTypeConcreteEntitySubTypes;
        PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> valueNodeBuilderDelegate;
        block8: {
            PojoTypeModel<?> inverseSideEntityType = typeNodeBuilder.getTypeModel();
            PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.getRawType();
            PojoRawTypeModel<?> originalSideRawConcreteEntityType = originalSideConcreteEntityType.getRawType();
            try {
                valueNodeBuilderDelegate = this.applyPath(typeNodeBuilder, inverseAssociationPath);
                PojoRawTypeModel<?> valueNodeRawType = valueNodeBuilderDelegate.getTypeModel().getRawType();
                if (valueNodeRawType.isSubTypeOf(originalSideRawConcreteEntityType)) {
                    valueNodeTypeConcreteEntitySubTypes = this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(valueNodeRawType);
                    break block8;
                }
                if (originalSideRawConcreteEntityType.isSubTypeOf(valueNodeRawType)) {
                    valueNodeTypeConcreteEntitySubTypes = this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(originalSideRawConcreteEntityType);
                    break block8;
                }
                throw log.incorrectTargetTypeForInverseAssociation(valueNodeRawType, originalSideRawConcreteEntityType);
            }
            catch (RuntimeException e) {
                throw log.cannotApplyInvertAssociationPath(inverseSideRawEntityType, inverseAssociationPath, originalSideRawConcreteEntityType, this.modelPathFromLastEntityNode.toUnboundPath(), e.getMessage(), e);
            }
        }
        PojoIndexingDependencyCollectorValueNode<?, ?> entityNodeParentValueNode = this.lastEntityNode.getParentNode();
        if (entityNodeParentValueNode != null) {
            for (PojoRawTypeModel<?> concreteEntityType : valueNodeTypeConcreteEntitySubTypes) {
                AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseValueTypeBuilder = valueNodeBuilderDelegate.type(concreteEntityType);
                entityNodeParentValueNode.markForReindexing(inverseValueTypeBuilder, dependencyPathFromInverseSideEntityTypeNode);
            }
        } else {
            for (PojoRawTypeModel<?> concreteEntityType : valueNodeTypeConcreteEntitySubTypes) {
                AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseValueTypeBuilder = valueNodeBuilderDelegate.type(concreteEntityType);
                inverseValueTypeBuilder.addDirtyPathTriggeringReindexing(dependencyPathFromInverseSideEntityTypeNode);
            }
        }
    }

    private PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> applyPath(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> builder, PojoModelPathValueNode unboundPath) {
        PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> propertyNodeBuilder = this.applyPath(builder, unboundPath.getParent());
        ContainerExtractorPath extractorPath = unboundPath.getExtractorPath();
        return propertyNodeBuilder.value(extractorPath);
    }

    private PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> applyPath(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> rootBuilder, PojoModelPathPropertyNode unboundPath) {
        PojoModelPathValueNode parent = unboundPath.getParent();
        AbstractPojoImplicitReindexingResolverTypeNodeBuilder parentBuilder = parent != null ? this.applyPath(rootBuilder, parent).type() : rootBuilder;
        String propertyName = unboundPath.getPropertyName();
        return parentBuilder.property(propertyName);
    }

    private PojoIndexingDependencyCollectorValueNode<?, ?> applyPath(PojoIndexingDependencyCollectorTypeNode<?> rootCollectorTypeNode, PojoModelPathValueNode unboundPath) {
        PojoIndexingDependencyCollectorPropertyNode<?, ?> propertyCollectorNode = this.applyPath(rootCollectorTypeNode, unboundPath.getParent());
        ContainerExtractorPath extractorPath = unboundPath.getExtractorPath();
        return propertyCollectorNode.value(extractorPath);
    }

    private PojoIndexingDependencyCollectorPropertyNode<?, ?> applyPath(PojoIndexingDependencyCollectorTypeNode<?> rootCollectorTypeNode, PojoModelPathPropertyNode unboundPath) {
        PojoModelPathValueNode parent = unboundPath.getParent();
        PojoIndexingDependencyCollectorTypeNode<?> parentCollectorNode = parent != null ? this.applyPath(rootCollectorTypeNode, parent).type() : rootCollectorTypeNode;
        String propertyName = unboundPath.getPropertyName();
        return parentCollectorNode.property(propertyName);
    }

    private BoundPojoModelPathValueNode<?, ?, ?> applyProcessingPathToSubType(PojoRawTypeModel<?> rootSubType, BoundPojoModelPathValueNode<?, ?, ?> source) {
        BoundPojoModelPathPropertyNode<?, ?> targetParent = this.applyProcessingPathToSubType(rootSubType, (BoundPojoModelPathPropertyNode<?, ?>)source.getParent());
        return this.bindAndApplyExtractorPath(targetParent, source.getExtractorPath());
    }

    private BoundPojoModelPathPropertyNode<?, ?> applyProcessingPathToSubType(PojoRawTypeModel<?> rootSubType, BoundPojoModelPathPropertyNode<?, ?> source) {
        BoundPojoModelPathTypeNode<?> targetParent = this.applyProcessingPathToSubType(rootSubType, (BoundPojoModelPathTypeNode<?>)source.getParent());
        return targetParent.property(source.getPropertyHandle());
    }

    private BoundPojoModelPathTypeNode<?> applyProcessingPathToSubType(PojoRawTypeModel<?> rootSubType, BoundPojoModelPathTypeNode<?> source) {
        BoundPojoModelPath sourceParent = source.getParent();
        if (sourceParent != null) {
            return this.applyProcessingPathToSubType(rootSubType, (BoundPojoModelPathValueNode<?, ?, ?>)sourceParent).type();
        }
        return BoundPojoModelPath.root(rootSubType);
    }

    private <T, P> BoundPojoModelPathValueNode<T, P, ?> bindAndApplyExtractorPath(BoundPojoModelPathPropertyNode<T, P> propertyNode, ContainerExtractorPath extractorPath) {
        BoundContainerExtractorPath<P, ?> boundExtractorPath = this.buildingHelper.bindExtractorPath(propertyNode.getPropertyModel().getTypeModel(), extractorPath);
        return propertyNode.value(boundExtractorPath);
    }
}

