/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.impl;

import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.util.impl.common.Contracts;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoImplicitReindexingResolverDirtinessFilterNode<T, S>
extends PojoImplicitReindexingResolverNode<T, S> {
    private final PojoPathFilter<S> dirtyPathFilter;
    private final PojoImplicitReindexingResolverNode<T, S> delegate;

    public PojoImplicitReindexingResolverDirtinessFilterNode(PojoPathFilter<S> dirtyPathFilter, PojoImplicitReindexingResolverNode<T, S> delegate) {
        Contracts.assertNotNull(dirtyPathFilter, (String)"dirtyPathFilter");
        this.dirtyPathFilter = dirtyPathFilter;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("dirtyPathFilter", this.dirtyPathFilter);
        builder.attribute("delegate", this.delegate);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, T dirty, S dirtinessState) {
        if (dirtinessState == null || this.dirtyPathFilter.test(dirtinessState)) {
            this.delegate.resolveEntitiesToReindex(collector, runtimeIntrospector, dirty, dirtinessState);
        }
    }
}

