/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;

class ChainingContainerExtractor<C, U, V>
implements ContainerExtractor<C, V> {
    private final ContainerExtractor<C, U> parent;
    private final ContainerExtractor<? super U, V> chained;

    ChainingContainerExtractor(ContainerExtractor<C, U> parent, ContainerExtractor<? super U, V> chained) {
        this.parent = parent;
        this.chained = chained;
    }

    @Override
    public Stream<V> extract(C container) {
        return this.parent.extract(container).flatMap(this.chained::extract);
    }

    public ContainerExtractor<C, U> getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        this.appendToString(builder, this, true);
        builder.append("]");
        return builder.toString();
    }

    private void appendToString(StringBuilder builder, ContainerExtractor<?, ?> extractor, boolean first) {
        if (extractor instanceof ChainingContainerExtractor) {
            ChainingContainerExtractor chaining = (ChainingContainerExtractor)extractor;
            this.appendToString(builder, chaining.parent, first);
            this.appendToString(builder, chaining.chained, false);
        } else {
            if (!first) {
                builder.append(", ");
            }
            builder.append(extractor);
        }
    }
}

