/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.util.Optional;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextExtension;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;

final class PojoIdentifierBridgeToDocumentIdentifierValueConverter<I>
implements ToDocumentIdentifierValueConverter<I> {
    private final IdentifierBridge<I> bridge;

    PojoIdentifierBridgeToDocumentIdentifierValueConverter(IdentifierBridge<I> bridge) {
        this.bridge = bridge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bridge + "]";
    }

    public String convert(I value, ToDocumentIdentifierValueConvertContext context) {
        IdentifierBridgeToDocumentIdentifierContext extension = (IdentifierBridgeToDocumentIdentifierContext)context.extension((ToDocumentIdentifierValueConvertContextExtension)PojoIdentifierBridgeContextExtension.INSTANCE);
        return this.bridge.toDocumentIdentifier(this.bridge.cast(value), extension);
    }

    public String convertUnknown(Object value, ToDocumentIdentifierValueConvertContext context) {
        return this.convert(this.bridge.cast(value), context);
    }

    public boolean isCompatibleWith(ToDocumentIdentifierValueConverter<?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoIdentifierBridgeToDocumentIdentifierValueConverter castedOther = (PojoIdentifierBridgeToDocumentIdentifierValueConverter)other;
        return this.bridge.isCompatibleWith(castedOther.bridge);
    }

    private static class PojoIdentifierBridgeContextExtension
    implements ToDocumentIdentifierValueConvertContextExtension<IdentifierBridgeToDocumentIdentifierContext> {
        private static final PojoIdentifierBridgeContextExtension INSTANCE = new PojoIdentifierBridgeContextExtension();

        private PojoIdentifierBridgeContextExtension() {
        }

        public Optional<IdentifierBridgeToDocumentIdentifierContext> extendOptional(ToDocumentIdentifierValueConvertContext original, MappingContextImplementor mappingContext) {
            if (mappingContext instanceof AbstractPojoMappingContextImplementor) {
                AbstractPojoMappingContextImplementor pojoMappingContext = (AbstractPojoMappingContextImplementor)mappingContext;
                return Optional.of(pojoMappingContext.getIdentifierBridgeToDocumentIdentifierContext());
            }
            return Optional.empty();
        }
    }
}

