/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ContainerExtractorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorHelper;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyFieldMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

abstract class PropertyFieldAnnotationProcessor<A extends Annotation>
extends PropertyAnnotationProcessor<A> {
    private final Class<A> annotationType;

    PropertyFieldAnnotationProcessor(AnnotationProcessorHelper helper, Class<A> annotationType) {
        super(helper);
        this.annotationType = annotationType;
    }

    @Override
    final Stream<? extends A> extractAnnotations(PojoPropertyModel<?> propertyModel) {
        return propertyModel.getAnnotationsByType(this.annotationType);
    }

    @Override
    final void doProcess(PropertyMappingContext mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, A annotation) {
        String cleanedUpRelativeFieldName = this.getName(annotation);
        if (cleanedUpRelativeFieldName.isEmpty()) {
            cleanedUpRelativeFieldName = null;
        }
        PropertyFieldMappingContext<?> fieldContext = this.initFieldMappingContext(mappingContext, propertyModel, annotation, cleanedUpRelativeFieldName);
        BridgeBuilder<? extends ValueBridge<?, ?>> builder = this.helper.createValueBridgeBuilder(this.getValueBridge(annotation), propertyModel);
        fieldContext.valueBridge(builder);
        ContainerExtractorPath extractorPath = this.helper.getExtractorPath(this.getExtractors(annotation));
        fieldContext.withExtractors(extractorPath);
        Projectable projectable = this.getProjectable(annotation);
        if (!Projectable.DEFAULT.equals((Object)projectable)) {
            fieldContext.projectable(projectable);
        }
    }

    abstract PropertyFieldMappingContext<?> initFieldMappingContext(PropertyMappingContext var1, PojoPropertyModel<?> var2, A var3, String var4);

    abstract String getName(A var1);

    abstract Projectable getProjectable(A var1);

    abstract ValueBridgeRef getValueBridge(A var1);

    abstract ContainerExtractorRef[] getExtractors(A var1);
}

