/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.function.Function;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.impl.BeanBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoPropertyMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyFieldMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.DelegatingPropertyMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.PojoCompositeFieldModelContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;

abstract class AbstractPropertyFieldMappingContext<S extends PropertyFieldMappingContext<?>, C extends StandardIndexFieldTypeContext<?, ?>>
extends DelegatingPropertyMappingContext
implements PojoPropertyMetadataContributor,
PropertyFieldMappingContext<S> {
    private final String relativeFieldName;
    private BridgeBuilder<? extends ValueBridge<?, ?>> bridgeBuilder;
    final PojoCompositeFieldModelContributor<C> fieldModelContributor;
    private ContainerExtractorPath extractorPath = ContainerExtractorPath.defaultExtractors();

    AbstractPropertyFieldMappingContext(PropertyMappingContext parent, String relativeFieldName, Function<StandardIndexFieldTypeContext<?, ?>, C> contextConverter) {
        super(parent);
        this.relativeFieldName = relativeFieldName;
        this.fieldModelContributor = new PojoCompositeFieldModelContributor<C>(contextConverter);
    }

    @Override
    public void contributeModel(PojoAdditionalMetadataCollectorPropertyNode collector) {
    }

    @Override
    public void contributeMapping(PojoMappingCollectorPropertyNode collector) {
        collector.value(this.extractorPath).valueBridge(this.bridgeBuilder, this.relativeFieldName, this.fieldModelContributor);
    }

    abstract S thisAsS();

    @Override
    public S projectable(Projectable projectable) {
        this.fieldModelContributor.add(c -> c.projectable(projectable));
        return this.thisAsS();
    }

    @Override
    public S valueBridge(Class<? extends ValueBridge<?, ?>> bridgeClass) {
        return this.valueBridge(BeanReference.of(bridgeClass));
    }

    @Override
    public S valueBridge(BeanReference<? extends ValueBridge<?, ?>> bridgeReference) {
        return this.valueBridge(new BeanBridgeBuilder(bridgeReference));
    }

    @Override
    public S valueBridge(BridgeBuilder<? extends ValueBridge<?, ?>> builder) {
        this.bridgeBuilder = builder;
        return this.thisAsS();
    }

    @Override
    public S withExtractors(ContainerExtractorPath extractorPath) {
        this.extractorPath = extractorPath;
        return this.thisAsS();
    }
}

