/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.impl.BeanBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.logging.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.mapping.building.spi.ErrorCollectingPojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.InitialPropertyMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.RoutingKeyBridgeMappingContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeBridgeMappingContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;

public class TypeMappingContextImpl
implements TypeMappingContext,
PojoMappingConfigurationContributor,
PojoTypeMetadataContributor {
    private final PojoRawTypeModel<?> typeModel;
    private String indexName;
    private final ErrorCollectingPojoTypeMetadataContributor children = new ErrorCollectingPojoTypeMetadataContributor();

    public TypeMappingContextImpl(PojoRawTypeModel<?> typeModel) {
        this.typeModel = typeModel;
    }

    @Override
    public void configure(MappingBuildContext buildContext, ConfigurationPropertySource propertySource, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        if (this.indexName != null) {
            try {
                configurationCollector.mapToIndex(this.typeModel, this.indexName);
            }
            catch (RuntimeException e) {
                buildContext.getFailureCollector().withContext(PojoEventContexts.fromType(this.typeModel)).add((Throwable)e);
            }
        }
        configurationCollector.collectContributor(this.typeModel, (Object)this);
    }

    @Override
    public void contributeModel(PojoAdditionalMetadataCollectorTypeNode collector) {
        this.children.contributeModel(collector);
    }

    @Override
    public void contributeMapping(PojoMappingCollectorTypeNode collector) {
        this.children.contributeMapping(collector);
    }

    @Override
    public TypeMappingContext indexed() {
        return this.indexed(this.typeModel.getJavaClass().getName());
    }

    @Override
    public TypeMappingContext indexed(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @Override
    public TypeMappingContext routingKeyBridge(Class<? extends RoutingKeyBridge> bridgeClass) {
        return this.routingKeyBridge((BeanReference<? extends RoutingKeyBridge>)BeanReference.of(bridgeClass));
    }

    @Override
    public TypeMappingContext routingKeyBridge(BeanReference<? extends RoutingKeyBridge> bridgeReference) {
        return this.routingKeyBridge(new BeanBridgeBuilder<RoutingKeyBridge>(bridgeReference));
    }

    @Override
    public TypeMappingContext routingKeyBridge(BridgeBuilder<? extends RoutingKeyBridge> builder) {
        this.children.add(new RoutingKeyBridgeMappingContributor(builder));
        return this;
    }

    @Override
    public TypeMappingContext bridge(Class<? extends TypeBridge> bridgeClass) {
        return this.bridge((BeanReference<? extends TypeBridge>)BeanReference.of(bridgeClass));
    }

    @Override
    public TypeMappingContext bridge(BeanReference<? extends TypeBridge> bridgeReference) {
        return this.bridge(new BeanBridgeBuilder<TypeBridge>(bridgeReference));
    }

    @Override
    public TypeMappingContext bridge(BridgeBuilder<? extends TypeBridge> builder) {
        this.children.add(new TypeBridgeMappingContributor(builder));
        return this;
    }

    @Override
    public PropertyMappingContext property(String propertyName) {
        PojoPropertyModel<?> propertyModel = this.typeModel.getProperty(propertyName);
        PropertyHandle propertyHandle = propertyModel.getHandle();
        InitialPropertyMappingContext child = new InitialPropertyMappingContext(this, propertyHandle);
        this.children.add(child);
        return child;
    }
}

