/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;
import org.hibernate.search.mapper.pojo.mapping.impl.IdentifierMapping;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.impl.common.Closer;

public class PropertyIdentifierMapping<I, E>
implements IdentifierMapping<I, E> {
    private final PojoCaster<? super I> caster;
    private final PropertyHandle property;
    private final BeanHolder<? extends IdentifierBridge<I>> bridgeHolder;

    public PropertyIdentifierMapping(PojoCaster<? super I> caster, PropertyHandle property, BeanHolder<? extends IdentifierBridge<I>> bridgeHolder) {
        this.caster = caster;
        this.property = property;
        this.bridgeHolder = bridgeHolder;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(holder -> ((IdentifierBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    @Override
    public I getIdentifier(Object providedId, Supplier<? extends E> entitySupplier) {
        if (providedId != null) {
            return this.caster.cast(providedId);
        }
        Object id = this.property.get(entitySupplier.get());
        return this.caster.cast(id);
    }

    @Override
    public String toDocumentIdentifier(I identifier, AbstractPojoMappingContextImplementor context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).toDocumentIdentifier(identifier, context.getIdentifierBridgeToDocumentIdentifierContext());
    }

    @Override
    public I fromDocumentIdentifier(String documentId, AbstractPojoSessionContextImplementor context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).fromDocumentIdentifier(documentId, context.getIdentifierBridgeFromDocumentIdentifierContext());
    }
}

