/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMapper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationMappingDefinitionContextImpl;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.ProgrammaticMappingDefinitionContextImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public abstract class AbstractPojoMappingInitiator<M>
implements MappingInitiator<PojoTypeMetadataContributor, M> {
    private final PojoMappingFactory<M> mappingFactory;
    private final PojoBootstrapIntrospector introspector;
    private boolean implicitProvidedId;
    private boolean multiTenancyEnabled;
    private final AnnotationMappingDefinitionContextImpl annotationMappingDefinition;
    private final List<PojoMappingConfigurationContributor> delegates = new ArrayList<PojoMappingConfigurationContributor>();

    protected AbstractPojoMappingInitiator(PojoMappingFactory<M> mappingFactory, PojoBootstrapIntrospector introspector) {
        this.mappingFactory = mappingFactory;
        this.introspector = introspector;
        this.annotationMappingDefinition = new AnnotationMappingDefinitionContextImpl(introspector);
        this.addConfigurationContributor(this.annotationMappingDefinition);
    }

    public ProgrammaticMappingDefinitionContext programmaticMapping() {
        ProgrammaticMappingDefinitionContextImpl definition = new ProgrammaticMappingDefinitionContextImpl(this.introspector);
        this.addConfigurationContributor(definition);
        return definition;
    }

    public AnnotationMappingDefinitionContext annotationMapping() {
        return this.annotationMappingDefinition;
    }

    public void setImplicitProvidedId(boolean implicitProvidedId) {
        this.implicitProvidedId = implicitProvidedId;
    }

    public void setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.multiTenancyEnabled = multiTenancyEnabled;
    }

    public void setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.annotationMappingDefinition.setAnnotatedTypeDiscoveryEnabled(annotatedTypeDiscoveryEnabled);
    }

    public void configure(MappingBuildContext buildContext, ConfigurationPropertySource propertySource, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        if (this.multiTenancyEnabled) {
            configurationCollector.enableMultiTenancy();
        }
        for (PojoMappingConfigurationContributor delegate : this.delegates) {
            delegate.configure(buildContext, propertySource, configurationCollector);
        }
    }

    public Mapper<M> createMapper(MappingBuildContext buildContext, ConfigurationPropertySource propertySource, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider) {
        return new PojoMapper(buildContext, propertySource, contributorProvider, this.introspector, this.implicitProvidedId, this.mappingFactory::createMapping);
    }

    protected final void addConfigurationContributor(PojoMappingConfigurationContributor contributor) {
        this.delegates.add(contributor);
    }
}

