/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.impl;

import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.PojoModelElementAccessor;
import org.hibernate.search.mapper.pojo.model.PojoModelProperty;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.impl.AbstractPojoModelCompositeElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelPropertyElementAccessor;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;

class PojoModelNestedCompositeElement<T, P>
extends AbstractPojoModelCompositeElement<P>
implements PojoModelProperty {
    private final AbstractPojoModelCompositeElement<T> parent;
    private final BoundPojoModelPathValueNode<T, P, P> modelPath;
    private final PojoPropertyAdditionalMetadata propertyAdditionalMetadata;

    PojoModelNestedCompositeElement(AbstractPojoModelCompositeElement<T> parent, BoundPojoModelPathPropertyNode<T, P> modelPath, PojoPropertyAdditionalMetadata propertyAdditionalMetadata, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider) {
        super(typeAdditionalMetadataProvider);
        this.parent = parent;
        this.modelPath = modelPath.valueWithoutExtractors();
        this.propertyAdditionalMetadata = propertyAdditionalMetadata;
    }

    @Override
    public <M> Stream<M> markers(Class<M> markerType) {
        return this.propertyAdditionalMetadata.getMarkers(markerType);
    }

    @Override
    public String getName() {
        return ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().getName();
    }

    public void contributeDependencies(PojoIndexingDependencyCollectorTypeNode<T> dependencyCollector) {
        if (this.hasAccessor()) {
            PojoIndexingDependencyCollectorPropertyNode<T, ?> collectorPropertyNode = dependencyCollector.property(this.getHandle());
            PojoIndexingDependencyCollectorValueNode<?, P> collectorValueNode = collectorPropertyNode.value(this.modelPath.getBoundExtractorPath());
            collectorValueNode.collectDependency();
            this.contributePropertyDependencies(collectorValueNode.type());
        }
    }

    @Override
    PojoModelElementAccessor<P> doCreateAccessor() {
        return new PojoModelPropertyElementAccessor(this.parent.createAccessor(), this.getHandle());
    }

    @Override
    BoundPojoModelPathTypeNode<P> getModelPathTypeNode() {
        return this.modelPath.type();
    }

    PropertyHandle getHandle() {
        return ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyHandle();
    }
}

