/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import java.util.Collection;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.model.impl.PojoElementImpl;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorPropertyNode;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoIndexingProcessorTypeNode<T>
extends PojoIndexingProcessor<T> {
    private final Iterable<IndexObjectFieldAccessor> parentObjectAccessors;
    private final Collection<BeanHolder<? extends TypeBridge>> bridgeHolders;
    private final Collection<PojoIndexingProcessorPropertyNode<? super T, ?>> propertyNodes;

    public PojoIndexingProcessorTypeNode(Iterable<IndexObjectFieldAccessor> parentObjectAccessors, Collection<BeanHolder<? extends TypeBridge>> bridgeHolders, Collection<PojoIndexingProcessorPropertyNode<? super T, ?>> propertyNodes) {
        this.parentObjectAccessors = parentObjectAccessors;
        this.bridgeHolders = bridgeHolders;
        this.propertyNodes = propertyNodes;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(holder -> ((TypeBridge)holder.get()).close(), this.bridgeHolders);
            closer.pushAll(BeanHolder::close, this.bridgeHolders);
            closer.pushAll(PojoIndexingProcessor::close, this.propertyNodes);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("objectAccessors", this.parentObjectAccessors);
        builder.startList("bridges");
        for (BeanHolder<? extends TypeBridge> beanHolder : this.bridgeHolders) {
            builder.value(beanHolder.get());
        }
        builder.endList();
        builder.startList("propertyNodes");
        for (PojoIndexingProcessorPropertyNode pojoIndexingProcessorPropertyNode : this.propertyNodes) {
            builder.value((Object)pojoIndexingProcessorPropertyNode);
        }
        builder.endList();
    }

    @Override
    public final void process(DocumentElement target, T source, AbstractPojoSessionContextImplementor sessionContext) {
        if (source == null) {
            return;
        }
        DocumentElement parentObject = target;
        for (IndexObjectFieldAccessor indexObjectFieldAccessor : this.parentObjectAccessors) {
            parentObject = indexObjectFieldAccessor.add(parentObject);
        }
        if (!this.bridgeHolders.isEmpty()) {
            PojoElementImpl bridgedElement = new PojoElementImpl(source);
            for (BeanHolder<? extends TypeBridge> beanHolder : this.bridgeHolders) {
                ((TypeBridge)beanHolder.get()).write(parentObject, bridgedElement, sessionContext.getTypeBridgeWriteContext());
            }
        }
        for (PojoIndexingProcessorPropertyNode pojoIndexingProcessorPropertyNode : this.propertyNodes) {
            pojoIndexingProcessorPropertyNode.process(parentObject, source, sessionContext);
        }
    }
}

