/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.ToStringTreeBuilder;

public class PojoIndexingProcessorValueBridgeNode<V, F>
extends PojoIndexingProcessor<V> {
    private final BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder;
    private final IndexFieldAccessor<? super F> indexFieldAccessor;

    public PojoIndexingProcessorValueBridgeNode(BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder, IndexFieldAccessor<? super F> indexFieldAccessor) {
        this.bridgeHolder = bridgeHolder;
        this.indexFieldAccessor = indexFieldAccessor;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(holder -> ((ValueBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("bridge", this.bridgeHolder);
        builder.attribute("indexFieldAccessor", this.indexFieldAccessor);
    }

    @Override
    public void process(DocumentElement target, V source, AbstractPojoSessionContextImplementor sessionContext) {
        Object indexFieldValue = ((ValueBridge)this.bridgeHolder.get()).toIndexedValue(source, sessionContext.getMappingContext().getToIndexedValueContext());
        this.indexFieldAccessor.write(target, indexFieldValue);
    }
}

