/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.util.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.util.impl.ReflectionUtils;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.Contracts;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class GenericTypeContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Type resolvedType;
    private final GenericTypeContext declaringContext;
    private final Map<TypeVariable<?>, Type> typeMappings;

    public GenericTypeContext(Type type) {
        this(null, type);
    }

    public GenericTypeContext(GenericTypeContext declaringContext, Type type) {
        Contracts.assertNotNull((Object)type, (String)"type");
        this.resolvedType = declaringContext != null ? declaringContext.resolveType(type) : type;
        this.declaringContext = declaringContext;
        this.typeMappings = new HashMap();
        this.populateTypeMappings(this.typeMappings, this.resolvedType);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.resolvedType.getTypeName() + ", " + this.declaringContext + "]";
    }

    public Type getResolvedType() {
        return this.resolvedType;
    }

    public GenericTypeContext getDeclaringContext() {
        return this.declaringContext;
    }

    public Optional<Type> resolveTypeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        TypeVariable<Class<?>>[] typeParameters = rawSuperType.getTypeParameters();
        int typeParametersLength = typeParameters.length;
        if (typeParametersLength == 0) {
            throw log.cannotRequestTypeParameterOfUnparameterizedType(this.resolvedType, rawSuperType, typeParameterIndex);
        }
        if (typeParametersLength <= typeParameterIndex) {
            throw log.typeParameterIndexOutOfBound(this.resolvedType, rawSuperType, typeParameterIndex, typeParametersLength);
        }
        if (typeParameterIndex < 0) {
            throw log.invalidTypeParameterIndex(this.resolvedType, rawSuperType, typeParameterIndex);
        }
        TypeVariable<Class<?>> typeVariable = typeParameters[typeParameterIndex];
        if (!this.typeMappings.containsKey(typeVariable)) {
            return Optional.empty();
        }
        return Optional.of(this.resolveType(typeVariable));
    }

    public Optional<Type> resolveArrayElementType() {
        return ReflectionUtils.getArrayElementType(this.getResolvedType()).map(this::resolveType);
    }

    private Type resolveType(Type type) {
        Type resolvedType = type;
        TypeVariable typeVariable = null;
        while (resolvedType instanceof TypeVariable && resolvedType != typeVariable) {
            typeVariable = (TypeVariable)resolvedType;
            if (typeVariable.getGenericDeclaration() instanceof Class) {
                resolvedType = this.typeMappings.get(typeVariable);
                continue;
            }
            resolvedType = typeVariable.getBounds()[0];
        }
        if (resolvedType == null && typeVariable != null) {
            if (this.declaringContext != null) {
                return this.declaringContext.resolveType(typeVariable);
            }
            return typeVariable;
        }
        return resolvedType;
    }

    private void populateTypeMappings(Map<TypeVariable<?>, Type> mappings, Type type) {
        if (type instanceof TypeVariable) {
            for (Type upperBound : ((TypeVariable)type).getBounds()) {
                this.populateTypeMappings(mappings, upperBound);
            }
        } else if (type instanceof WildcardType) {
            for (Type upperBound : ((WildcardType)type).getUpperBounds()) {
                this.populateTypeMappings(mappings, upperBound);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> rawType = ReflectionUtils.getRawType(parameterizedType);
            TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                mappings.put(typeParameters[i], typeArguments[i]);
            }
            this.populateTypeMappings(mappings, rawType);
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            for (TypeVariable typeParameter : clazz.getTypeParameters()) {
                mappings.putIfAbsent(typeParameter, typeParameter);
            }
            for (Type interfaze : clazz.getGenericInterfaces()) {
                this.populateTypeMappings(mappings, interfaze);
            }
            Type superClass = clazz.getGenericSuperclass();
            if (superClass != null) {
                this.populateTypeMappings(mappings, superClass);
            }
        } else if (!(type instanceof GenericArrayType)) {
            throw new AssertionFailure("Unexpected java.lang.reflect.Type type: " + type.getClass());
        }
    }
}

