/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.util.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class AnnotationHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final MethodHandles.Lookup lookup;
    private final Map<Class<? extends Annotation>, MethodHandle> containedAnnotationsHandleCache = new HashMap<Class<? extends Annotation>, MethodHandle>();

    public AnnotationHelper(MethodHandles.Lookup lookup) {
        this.lookup = lookup;
    }

    public <A extends Annotation> Optional<A> getAnnotationByType(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return Optional.ofNullable(annotatedElement.getAnnotation(annotationType));
    }

    public <A extends Annotation> Stream<A> getAnnotationsByType(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return Arrays.stream(annotatedElement.getAnnotationsByType(annotationType));
    }

    public Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(AnnotatedElement annotatedElement, Class<? extends Annotation> metaAnnotationType) {
        return Arrays.stream(annotatedElement.getAnnotations()).flatMap(this::expandRepeatableContainingAnnotation).filter(annotation -> this.isMetaAnnotated((Annotation)annotation, metaAnnotationType));
    }

    public boolean isMetaAnnotated(Annotation annotation, Class<? extends Annotation> metaAnnotationType) {
        return annotation.annotationType().getAnnotationsByType(metaAnnotationType).length > 0;
    }

    public Stream<? extends Annotation> expandRepeatableContainingAnnotation(Annotation containingAnnotationCandidate) {
        Class<? extends Annotation> containingAnnotationCandidateType = containingAnnotationCandidate.annotationType();
        MethodHandle containedAnnotationsHandle = this.containedAnnotationsHandleCache.computeIfAbsent(containingAnnotationCandidateType, this::createContainedAnnotationsHandle);
        if (containedAnnotationsHandle != null) {
            try {
                Annotation[] annotationArray = containedAnnotationsHandle.invoke(containingAnnotationCandidate);
                return Arrays.stream(annotationArray);
            }
            catch (Throwable e) {
                log.cannotAccessRepeateableContainingAnnotationValue(containingAnnotationCandidateType, e);
            }
        }
        return Stream.of(containingAnnotationCandidate);
    }

    private MethodHandle createContainedAnnotationsHandle(Class<? extends Annotation> containingAnnotationCandidateType) {
        Repeatable repeatable;
        Class<?> elementType;
        Method valueMethod;
        try {
            valueMethod = containingAnnotationCandidateType.getDeclaredMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        Class<?> valueMethodReturnType = valueMethod.getReturnType();
        if (valueMethodReturnType.isArray() && Annotation.class.isAssignableFrom(elementType = valueMethodReturnType.getComponentType()) && (repeatable = elementType.getAnnotation(Repeatable.class)) != null && containingAnnotationCandidateType.equals(repeatable.value())) {
            try {
                return this.lookup.unreflect(valueMethod);
            }
            catch (IllegalAccessException e) {
                log.cannotAccessRepeateableContainingAnnotationValue(containingAnnotationCandidateType, e);
            }
        }
        return null;
    }
}

