/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.work.spi.PojoMappingWorkExecutor;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class PojoMappingWorkExecutorImpl
implements PojoMappingWorkExecutor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexedTypeManagerContainer indexedTypeManagers;
    private Map<Class<?>, IndexWorkExecutor> workExecutors = new HashMap();

    public PojoMappingWorkExecutorImpl(PojoIndexedTypeManagerContainer indexedTypeManagers) {
        this.indexedTypeManagers = indexedTypeManagers;
    }

    @Override
    public CompletableFuture<?> optimize(Collection<Class<?>> types) {
        return this.doOperationOnTypes(IndexWorkExecutor::optimize, types);
    }

    @Override
    public CompletableFuture<?> purge(Collection<Class<?>> types, String tenantId) {
        return this.doOperationOnTypes(workExecutor -> workExecutor.purge(tenantId), types);
    }

    @Override
    public CompletableFuture<?> flush(Collection<Class<?>> types) {
        return this.doOperationOnTypes(IndexWorkExecutor::flush, types);
    }

    private CompletableFuture<?> doOperationOnTypes(Function<IndexWorkExecutor, CompletableFuture<?>> operation, Collection<Class<?>> types) {
        CompletableFuture[] futures = new CompletableFuture[types.size()];
        int typeCounter = 0;
        for (Class<?> type : types) {
            if (!this.workExecutors.containsKey(type)) {
                this.workExecutors.put(type, this.createWorkExecutor(type));
            }
            futures[typeCounter++] = operation.apply(this.workExecutors.get(type));
        }
        return CompletableFuture.allOf(futures);
    }

    private IndexWorkExecutor createWorkExecutor(Class<?> clazz) {
        Optional<PojoIndexedTypeManager<?, ?, ?>> exactClass = this.indexedTypeManagers.getByExactClass(clazz);
        if (!exactClass.isPresent()) {
            throw log.notDirectlyIndexedType(clazz);
        }
        return exactClass.get().createWorkExecutor();
    }
}

