/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultCharacterValueBridge
implements ValueBridge<Character, String> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<Character> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultCharacterFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public String toIndexedValue(Character value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : Character.toString(value.charValue());
    }

    @Override
    public Character cast(Object value) {
        return (Character)value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultCharacterFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<String, Character> {
        private static final PojoDefaultCharacterFromDocumentFieldValueConverter INSTANCE = new PojoDefaultCharacterFromDocumentFieldValueConverter();

        private PojoDefaultCharacterFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(Character.class);
        }

        public Character convert(String value, FromDocumentFieldValueConvertContext context) {
            return value == null || value.isEmpty() ? null : Character.valueOf(value.charAt(0));
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

