/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;

public final class DefaultEnumIdentifierBridge<T extends Enum<T>>
implements IdentifierBridge<T> {
    private Class<T> enumType;

    @Override
    public void bind(IdentifierBridgeBindingContext<T> context) {
        this.enumType = context.getBridgedElement().getRawType();
    }

    @Override
    public String toDocumentIdentifier(T propertyValue, IdentifierBridgeToDocumentIdentifierContext context) {
        return ((Enum)propertyValue).name();
    }

    @Override
    public T fromDocumentIdentifier(String documentIdentifier, IdentifierBridgeFromDocumentIdentifierContext context) {
        return Enum.valueOf(this.enumType, documentIdentifier);
    }

    @Override
    public T cast(Object value) {
        return (T)((Enum)this.enumType.cast(value));
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DefaultEnumIdentifierBridge castedOther = (DefaultEnumIdentifierBridge)other;
        return this.enumType.equals(castedOther.enumType);
    }
}

