/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultEnumValueBridge<V extends Enum<V>>
implements ValueBridge<V, String> {
    private Class<V> enumType;

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.enumType.getName() + "]";
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<V> context) {
        this.enumType = context.getBridgedElement().getRawType();
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter(new PojoDefaultEnumFromDocumentFieldValueConverter(this.enumType));
    }

    @Override
    public String toIndexedValue(V value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : ((Enum)value).name();
    }

    @Override
    public V cast(Object value) {
        return (V)((Enum)this.enumType.cast(value));
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DefaultEnumValueBridge castedOther = (DefaultEnumValueBridge)other;
        return this.enumType.equals(castedOther.enumType);
    }

    private static class PojoDefaultEnumFromDocumentFieldValueConverter<V extends Enum<V>>
    implements FromDocumentFieldValueConverter<String, V> {
        private final Class<V> enumType;

        private PojoDefaultEnumFromDocumentFieldValueConverter(Class<V> enumType) {
            this.enumType = enumType;
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(this.enumType);
        }

        public V convert(String indexedValue, FromDocumentFieldValueConvertContext context) {
            return indexedValue == null ? null : (V)Enum.valueOf(this.enumType, indexedValue);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            PojoDefaultEnumFromDocumentFieldValueConverter castedOther = (PojoDefaultEnumFromDocumentFieldValueConverter)other;
            return this.enumType.equals(castedOther.enumType);
        }
    }
}

