/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultJavaNetURIValueBridge
implements ValueBridge<URI, String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<URI> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultURIFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public String toIndexedValue(URI value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.toString();
    }

    @Override
    public URI cast(Object value) {
        return (URI)value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultURIFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<String, URI> {
        private static final PojoDefaultURIFromDocumentFieldValueConverter INSTANCE = new PojoDefaultURIFromDocumentFieldValueConverter();

        private PojoDefaultURIFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(URI.class);
        }

        public URI convert(String value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : PojoDefaultURIFromDocumentFieldValueConverter.toURI(value);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }

        private static URI toURI(String value) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw log.badURISyntax(value, e);
            }
        }
    }
}

