/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultJavaNetURLValueBridge
implements ValueBridge<URL, String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<URL> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultURLFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public String toIndexedValue(URL value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.toExternalForm();
    }

    @Override
    public URL cast(Object value) {
        return (URL)value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultURLFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<String, URL> {
        private static final PojoDefaultURLFromDocumentFieldValueConverter INSTANCE = new PojoDefaultURLFromDocumentFieldValueConverter();

        private PojoDefaultURLFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(URL.class);
        }

        public URL convert(String value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : PojoDefaultURLFromDocumentFieldValueConverter.toURL(value);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }

        private static URL toURL(String value) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw log.malformedURL(value, e);
            }
        }
    }
}

