/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.util.UUID;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultUUIDValueBridge
implements ValueBridge<UUID, String> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<UUID> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultUUIDFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public String toIndexedValue(UUID value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.toString();
    }

    @Override
    public UUID cast(Object value) {
        return (UUID)value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultUUIDFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<String, UUID> {
        private static final PojoDefaultUUIDFromDocumentFieldValueConverter INSTANCE = new PojoDefaultUUIDFromDocumentFieldValueConverter();

        private PojoDefaultUUIDFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(UUID.class);
        }

        public UUID convert(String value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : UUID.fromString(value);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

