/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import org.hibernate.search.mapper.pojo.dirtiness.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.util.common.AssertionFailure;

public class PojoIndexingDependencyCollectorTypeNode<T>
extends AbstractPojoIndexingDependencyCollectorNode {
    private final PojoIndexingDependencyCollectorValueNode<?, T> parentNode;
    private final BoundPojoModelPathTypeNode<T> modelPathFromCurrentNode;
    private final PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode;
    private final BoundPojoModelPathTypeNode<T> modelPathFromLastEntityNode;
    private final BoundPojoModelPathTypeNode<T> modelPathFromRootEntityNode;

    PojoIndexingDependencyCollectorTypeNode(PojoRawTypeModel<T> typeModel, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = null;
        this.modelPathFromCurrentNode = BoundPojoModelPath.root(typeModel);
        this.lastEntityNode = this;
        this.modelPathFromLastEntityNode = this.modelPathFromCurrentNode;
        this.modelPathFromRootEntityNode = this.modelPathFromCurrentNode;
    }

    PojoIndexingDependencyCollectorTypeNode(PojoIndexingDependencyCollectorValueNode<?, T> parentNode, PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode, BoundPojoModelPathTypeNode<T> modelPathFromLastEntityNode, BoundPojoModelPathTypeNode<T> modelPathFromRootEntityNode, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        PojoTypeModel<T> typeModel = modelPathFromRootEntityNode.getTypeModel();
        this.modelPathFromCurrentNode = BoundPojoModelPath.root(typeModel);
        if (buildingHelper.isEntity(typeModel.getRawType())) {
            this.lastEntityNode = this;
            this.modelPathFromLastEntityNode = this.modelPathFromCurrentNode;
        } else {
            this.lastEntityNode = lastEntityNode;
            this.modelPathFromLastEntityNode = modelPathFromLastEntityNode;
        }
        this.modelPathFromRootEntityNode = modelPathFromRootEntityNode;
    }

    public PojoIndexingDependencyCollectorPropertyNode<T, ?> property(PropertyHandle propertyHandle) {
        return new PojoIndexingDependencyCollectorPropertyNode(this, this.modelPathFromCurrentNode.property(propertyHandle), this.lastEntityNode, this.modelPathFromLastEntityNode.property(propertyHandle), this.modelPathFromRootEntityNode.property(propertyHandle), this.buildingHelper);
    }

    PojoIndexingDependencyCollectorPropertyNode<T, ?> property(String propertyName) {
        PojoPropertyModel<?> propertyModel = this.getTypeModel().getProperty(propertyName);
        return this.property(propertyModel.getHandle());
    }

    @Override
    ReindexOnUpdate getReindexOnUpdate() {
        return this.parentNode == null ? ReindexOnUpdate.DEFAULT : this.parentNode.getReindexOnUpdate();
    }

    void collectDependency(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        if (this.lastEntityNode != this) {
            throw new AssertionFailure("collectDependency() called on a non-entity node");
        }
        PojoRawTypeModel<T> rawType = this.modelPathFromRootEntityNode.getTypeModel().getRawType();
        if (this.parentNode == null) {
            PojoImplicitReindexingResolverBuilder<T> builder = this.buildingHelper.getOrCreateResolverBuilder(rawType);
            builder.addDirtyPathTriggeringSelfReindexing(dirtyPathFromEntityType);
        } else {
            for (PojoRawTypeModel<?> concreteEntityType : this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(rawType)) {
                PojoImplicitReindexingResolverOriginalTypeNodeBuilder<?> builder = this.buildingHelper.getOrCreateResolverBuilder(concreteEntityType).containingEntitiesResolverRoot();
                this.parentNode.markForReindexing(builder, dirtyPathFromEntityType);
            }
        }
    }

    PojoIndexingDependencyCollectorValueNode<?, T> getParentNode() {
        return this.parentNode;
    }

    PojoTypeModel<T> getTypeModel() {
        return this.modelPathFromRootEntityNode.getTypeModel();
    }
}

