/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.impl;

import java.util.Collection;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoImplicitReindexingResolverContainerElementNode<C, S, V>
extends PojoImplicitReindexingResolverNode<C, S> {
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final Collection<PojoImplicitReindexingResolverNode<V, S>> nestedNodes;

    public PojoImplicitReindexingResolverContainerElementNode(ContainerExtractorHolder<C, V> extractorHolder, Collection<PojoImplicitReindexingResolverNode<V, S>> nestedNodes) {
        this.extractorHolder = extractorHolder;
        this.nestedNodes = nestedNodes;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.extractorHolder);
            closer.pushAll(PojoImplicitReindexingResolverNode::close, this.nestedNodes);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("extractor", this.extractorHolder.get());
        builder.startList("nestedNodes");
        for (PojoImplicitReindexingResolverNode<V, S> nestedNode : this.nestedNodes) {
            builder.value(nestedNode);
        }
        builder.endList();
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, C dirty, S dirtinessState) {
        try (Stream<V> stream = this.extractorHolder.get().extract(dirty);){
            stream.forEach(containerElement -> this.resolveEntitiesToReindexForContainerElement(collector, runtimeIntrospector, containerElement, dirtinessState));
        }
    }

    private void resolveEntitiesToReindexForContainerElement(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, V containerElement, S dirtinessState) {
        if (containerElement != null) {
            for (PojoImplicitReindexingResolverNode<V, S> node : this.nestedNodes) {
                node.resolveEntitiesToReindex(collector, runtimeIntrospector, containerElement, dirtinessState);
            }
        }
    }
}

