/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.ArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.CollectionElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.IterableElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.MapValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalDoubleValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalIntValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalLongValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ChainingContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExtractingTypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.mapper.pojo.util.impl.GenericTypeContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ContainerExtractorBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final TypePatternMatcherFactory typePatternMatcherFactory;
    private final FirstMatchingExtractorContributor firstMatchingExtractorContributor = new FirstMatchingExtractorContributor();
    private final Map<Class<? extends ContainerExtractor>, ExtractorContributor> extractorContributorCache = new HashMap<Class<? extends ContainerExtractor>, ExtractorContributor>();

    public ContainerExtractorBinder(MappingBuildContext buildContext, TypePatternMatcherFactory typePatternMatcherFactory) {
        this.beanProvider = buildContext.getServiceManager().getBeanProvider();
        this.typePatternMatcherFactory = typePatternMatcherFactory;
        this.addDefaultExtractor(MapValueExtractor.class);
        this.addDefaultExtractor(CollectionElementExtractor.class);
        this.addDefaultExtractor(IterableElementExtractor.class);
        this.addDefaultExtractor(OptionalValueExtractor.class);
        this.addDefaultExtractor(OptionalIntValueExtractor.class);
        this.addDefaultExtractor(OptionalLongValueExtractor.class);
        this.addDefaultExtractor(OptionalDoubleValueExtractor.class);
        this.addDefaultExtractor(ArrayElementExtractor.class);
    }

    public <C> Optional<BoundContainerExtractorPath<C, ?>> tryBindPath(PojoGenericTypeModel<C> sourceType, ContainerExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (Class<? extends ContainerExtractor> clazz : extractorPath.getExplicitExtractorClasses()) {
                ExtractorContributor extractorContributor = this.getExtractorContributorForClass(clazz);
                if (extractorContributor.tryAppend(state)) continue;
                return Optional.empty();
            }
        }
        return Optional.of(state.build());
    }

    public <C> BoundContainerExtractorPath<C, ?> bindPath(PojoGenericTypeModel<C> sourceType, ContainerExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (Class<? extends ContainerExtractor> clazz : extractorPath.getExplicitExtractorClasses()) {
                ExtractorContributor extractorContributor = this.getExtractorContributorForClass(clazz);
                if (extractorContributor.tryAppend(state)) continue;
                throw log.invalidContainerExtractorForType(clazz, ((ExtractorResolutionState)state).extractedType);
            }
        }
        return state.build();
    }

    public <C, V> ContainerExtractorHolder<C, V> create(BoundContainerExtractorPath<C, V> boundPath) {
        if (boundPath.getExtractorPath().isEmpty()) {
            throw new AssertionFailure("Received a request to create extractors, but the extractor path was empty. There is probably a bug in Hibernate Search.");
        }
        ChainingContainerExtractor extractor = null;
        ArrayList beanHolders = new ArrayList();
        try {
            for (Class<? extends ContainerExtractor> clazz : boundPath.getExtractorPath().getExplicitExtractorClasses()) {
                BeanHolder newExtractorHolder = this.beanProvider.getBean(clazz);
                beanHolders.add(newExtractorHolder);
                if (extractor == null) {
                    extractor = (ChainingContainerExtractor)newExtractorHolder.get();
                    continue;
                }
                extractor = new ChainingContainerExtractor(extractor, (ContainerExtractor)newExtractorHolder.get());
            }
            return new ContainerExtractorHolder(extractor, beanHolders);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(BeanHolder::close, beanHolders);
            throw e;
        }
    }

    public boolean isDefaultExtractorPath(PojoGenericTypeModel<?> sourceType, ContainerExtractorPath extractorPath) {
        Optional<BoundContainerExtractorPath<?, ?>> boundDefaultExtractorPathOptional = this.tryBindPath(sourceType, ContainerExtractorPath.defaultExtractors());
        return boundDefaultExtractorPathOptional.isPresent() && extractorPath.equals(boundDefaultExtractorPathOptional.get().getExtractorPath());
    }

    private void addDefaultExtractor(Class<? extends ContainerExtractor> extractorClass) {
        ExtractorContributor extractorContributor = this.getExtractorContributorForClass(extractorClass);
        this.firstMatchingExtractorContributor.addCandidate(extractorContributor);
    }

    private ExtractorContributor getExtractorContributorForClass(Class<? extends ContainerExtractor> extractorClass) {
        return this.extractorContributorCache.computeIfAbsent(extractorClass, this::createExtractorContributorForClass);
    }

    private ExtractorContributor createExtractorContributorForClass(Class<? extends ContainerExtractor> extractorClass) {
        ExtractingTypePatternMatcher typePatternMatcher;
        GenericTypeContext typeContext = new GenericTypeContext(extractorClass);
        Type typePattern = typeContext.resolveTypeArgument(ContainerExtractor.class, 0).orElseThrow(() -> log.cannotInferContainerExtractorClassTypePattern(extractorClass));
        Type typeToExtract = typeContext.resolveTypeArgument(ContainerExtractor.class, 1).orElseThrow(() -> log.cannotInferContainerExtractorClassTypePattern(extractorClass));
        try {
            typePatternMatcher = this.typePatternMatcherFactory.createExtractingMatcher(typePattern, typeToExtract);
        }
        catch (UnsupportedOperationException e) {
            throw log.cannotInferContainerExtractorClassTypePattern(extractorClass);
        }
        return new SingleExtractorContributor(typePatternMatcher, extractorClass);
    }

    private static class ExtractorResolutionState<C> {
        private final List<Class<? extends ContainerExtractor>> extractorClasses = new ArrayList<Class<? extends ContainerExtractor>>();
        private final PojoGenericTypeModel<C> sourceType;
        private PojoGenericTypeModel<?> extractedType;

        ExtractorResolutionState(PojoGenericTypeModel<C> sourceType) {
            this.sourceType = sourceType;
            this.extractedType = sourceType;
        }

        void append(Class<? extends ContainerExtractor> extractorClass, PojoGenericTypeModel<?> extractedType) {
            this.extractorClasses.add(extractorClass);
            this.extractedType = extractedType;
        }

        BoundContainerExtractorPath<C, ?> build() {
            return new BoundContainerExtractorPath(this.sourceType, ContainerExtractorPath.explicitExtractors(this.extractorClasses), this.extractedType);
        }
    }

    private static class FirstMatchingExtractorContributor
    implements ExtractorContributor {
        private final List<ExtractorContributor> candidates = new ArrayList<ExtractorContributor>();

        private FirstMatchingExtractorContributor() {
        }

        void addCandidate(ExtractorContributor contributor) {
            this.candidates.add(contributor);
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            for (ExtractorContributor extractorContributor : this.candidates) {
                if (!extractorContributor.tryAppend(state)) continue;
                this.tryAppend(state);
                return true;
            }
            return false;
        }
    }

    private class SingleExtractorContributor
    implements ExtractorContributor {
        private final ExtractingTypePatternMatcher typePatternMatcher;
        private final Class<? extends ContainerExtractor> extractorClass;

        SingleExtractorContributor(ExtractingTypePatternMatcher typePatternMatcher, Class<? extends ContainerExtractor> extractorClass) {
            this.typePatternMatcher = typePatternMatcher;
            this.extractorClass = extractorClass;
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            Optional<PojoGenericTypeModel<?>> resultTypeOptional = this.typePatternMatcher.extract(((ExtractorResolutionState)state).extractedType);
            if (resultTypeOptional.isPresent()) {
                state.append(this.extractorClass, resultTypeOptional.get());
                return true;
            }
            return false;
        }
    }

    private static interface ExtractorContributor {
        public boolean tryAppend(ExtractorResolutionState<?> var1);
    }
}

