/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.BuiltinContainerExtractor;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EnumFormatter;
import org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=700000, max=709999), @ValidIdRange(min=216, max=216), @ValidIdRange(min=295, max=295), @ValidIdRange(min=297, max=297)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 700000;

    @Message(id=216, value="An IndexedEmbedded defines includePaths filters that do not match anything. Non-matching includePaths filters: %1$s. Encountered field paths: %2$s. Check the filters for typos, or remove them if they are not useful.")
    public SearchException uselessIncludePathFilters(Set<String> var1, Set<String> var2);

    @Message(id=295, value="String '$1%s' cannot be parsed into a '$2%s'")
    public SearchException parseException(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Cause Exception var3);

    @Message(id=297, value=" Value of '%2$s' for type '%1$s' is too big for the conversion")
    public SearchException valueTooLargeForConversionException(@FormatWith(value=ClassFormatter.class) Class<?> var1, Object var2, @Cause Exception var3);

    @Message(id=700001, value="Unable to find a default identifier bridge implementation for type '%1$s'")
    public SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1);

    @Message(id=700002, value="Unable to find a default value bridge implementation for type '%1$s'")
    public SearchException unableToResolveDefaultValueBridgeFromSourceType(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1);

    @Message(id=700003, value="Annotation type '%2$s' is annotated with '%1$s', but neither a bridge reference nor a bridge builder reference was provided.")
    public SearchException missingBridgeReferenceInBridgeMapping(@FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var1, @FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var2);

    @Message(id=700004, value="Annotation type '%2$s' is annotated with '%1$s', but the marker builder reference is empty.")
    public SearchException missingBuilderReferenceInMarkerMapping(@FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var1, @FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var2);

    @Message(id=700005, value="Annotation @GenericField on property '%1$s' defines both valueBridge and valueBridgeBuilder. Only one of those can be defined, not both.")
    public SearchException invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference(String var1);

    @Message(id=700006, value="Annotation @DocumentId on property '%1$s' defines both identifierBridge and identifierBridgeBuilder. Only one of those can be defined, not both.")
    public SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference(String var1);

    @Message(id=700007, value="Cannot query on an empty target. If you want to target all indexes, put Object.class in the collection of target types, or use the method of the same name, but without Class<?> parameters.")
    public SearchException cannotSearchOnEmptyTarget();

    @Message(id=700008, value="Could not auto-detect the input type for value bridge '%1$s'. There is a bug in Hibernate Search, please report it.")
    public AssertionFailure unableToInferValueBridgeInputType(ValueBridge<?, ?> var1);

    @Message(id=700009, value="Could not auto-detect the return type for value bridge '%1$s'. There is a bug in Hibernate Search, please report it.")
    public AssertionFailure unableToInferValueBridgeIndexFieldType(ValueBridge<?, ?> var1);

    @Message(id=700010, value="Value bridge '%1$s' cannot be applied to input type '%2$s'.")
    public SearchException invalidInputTypeForValueBridge(ValueBridge<?, ?> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var2);

    @Message(id=700011, value="Missing field name for GeoPointBridge on type %1$s. The field name is mandatory when the bridge is applied on an type, optional when applied on a property.")
    public SearchException missingFieldNameForGeoPointBridgeOnType(String var1);

    @Message(id=700012, value="Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter")
    public IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3);

    @Message(id=700013, value="Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s)")
    public IllegalArgumentException typeParameterIndexOutOfBound(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3, int var4);

    @Message(id=700014, value="Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater")
    public IllegalArgumentException invalidTypeParameterIndex(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3);

    @Message(id=700015, value="Cannot interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>")
    public SearchException cannotInferContainerExtractorClassTypePattern(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=700016, value="Cannot apply the requested container value extractor '%1$s' to type '%2$s'")
    public SearchException invalidContainerExtractorForType(@FormatWith(value=ClassFormatter.class) Class<? extends ContainerExtractor> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoGenericTypeModel<?> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700017, value="Created POJO indexed type manager: %1$s")
    public void createdPojoIndexedTypeManager(@FormatWith(value=ToStringTreeAppendableMultilineFormatter.class) PojoIndexedTypeManager<?, ?, ?> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700018, value="Detected entity types: %1$s")
    public void detectedEntityTypes(Set<PojoRawTypeModel<?>> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700019, value="Created POJO contained type manager: %1$s")
    public void createdPojoContainedTypeManager(@FormatWith(value=ToStringTreeAppendableMultilineFormatter.class) PojoContainedTypeManager<?> var1);

    @Message(id=700020, value="Cannot find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO).")
    public SearchException cannotInvertAssociationForReindexing(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var3);

    @Message(id=700021, value="Cannot apply the path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%5$s'")
    public SearchException cannotApplyInvertAssociationPath(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var3, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var4, String var5, @Cause Exception var6);

    @Message(id=700022, value="The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.")
    public SearchException incorrectTargetTypeForInverseAssociation(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2);

    @Message(id=700023, value="Property '%2$s' from type '%1$s' is annotated with @AssociationInverseSide, but the inverse path is empty.")
    public SearchException missingInversePathInAssociationInverseSideMapping(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2);

    @Message(id=700024, value="Found an infinite embedded recursion involving path '%2$s' on type '%1$s'")
    public SearchException infiniteRecursionForAssociationEmbeddeds(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=700025, value="Cannot access the value of containing annotation '%1$s'. Ignoring annotation.")
    public void cannotAccessRepeateableContainingAnnotationValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Throwable var2);

    @Message(id=700026, value="Annotation type '%2$s' is annotated with '%1$s', but both a bridge reference and a bridge builder reference were provided. Only one can be provided.")
    public SearchException conflictingBridgeReferenceInBridgeMapping(@FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var1, @FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var2);

    @Message(id=700027, value="Type '%1$s' is not marked as an entity type, yet it is indexed or targeted by an association from an indexed type. Please check your configuration.")
    public SearchException missingEntityTypeMetadata(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700028, value="There isn't any explicit document ID mapping for indexed type '%1$s', and the entity ID cannot be used as a default because it is unknown.")
    public SearchException missingIdentifierMapping(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700029, value="Property '%2$s' from type '%1$s' is annotated with @IndexingDependency, but 'derivedFrom' contains an empty path.")
    public SearchException missingPathInIndexingDependencyDerivedFrom(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2);

    @Message(id=700030, value="Found a cyclic dependency between derived properties involving path '%2$s' on type '%1$s'. Derived properties cannot be marked as derived from themselves, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.")
    public SearchException infiniteRecursionForDerivedFrom(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var2);

    @Message(id=700031, value="This property is mapped to a full-text field, but with a value bridge that creates a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: the value bridge's bind() method returned context '%1$s', which does not extend the expected '%2$s' interface.")
    public SearchException invalidFieldEncodingForFullTextFieldMapping(StandardIndexFieldTypeContext<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700032, value="This property is mapped to a keyword field, but with a value bridge that creates a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: the value bridge's bind() method returned context '%1$s', which does not extend the expected '%2$s' interface.")
    public SearchException invalidFieldEncodingForKeywordFieldMapping(StandardIndexFieldTypeContext<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700033, value="Exception while invoking '%1$s' on '%2$s'.")
    public SearchException errorInvokingMember(Member var1, Object var2, @Cause Throwable var3);

    @Message(id=700034, value="Could not find a property with the '%1$s' marker for field '%2$s' (marker set: '%3$s').")
    public SearchException propertyMarkerNotFound(String var1, String var2, String var3);

    @Message(id=700035, value="Found multiple properties with the '%1$s' marker for field '%2$s' (marker set: '%3$s').")
    public SearchException multiplePropertiesForMarker(String var1, String var2, String var3);

    @Message(id=700036, value="Type '%1$s' is not indexed and hasn't any indexed supertype.")
    public SearchException notIndexedType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=700037, value="Cannot work on type %1$s, because it is not indexed, neither directly nor as a contained entity in another type.")
    public SearchException notIndexedTypeNorAsDelegate(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=700038, value="The identifier for this entity should always be provided, but the provided identifier was null.")
    public SearchException nullProvidedIdentifier();

    @Message(id=700039, value="Requested incompatible type for '%1$s': '%2$s'")
    public SearchException incompatibleRequestedType(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700040, value="Cannot work on type %1$s, because it is not directly indexed.")
    public SearchException notDirectlyIndexedType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=700041, value="Annotation @ContainerExtractorRef requests automatic resolution of the container extractor, but automatic resolution cannot be used in extractor chains. Use explicit references to the type of each extractor to be applied instead.")
    public SearchException cannotUseAutomaticContainerExtractorInMultiExtractorChain();

    @Message(id=700042, value="Annotation @ContainerExtractorRef references both built-in extractor (using '%1$s') and an explicit type (using '%2$s'). Only one of those can be defined, not both.")
    public SearchException invalidContainerExtractorReferencingBothBuiltinExtractorAndExplicitType(@FormatWith(value=EnumFormatter.class) BuiltinContainerExtractor var1, @FormatWith(value=ClassFormatter.class) Class<? extends ContainerExtractor> var2);

    @Message(id=700043, value="Error creating URL from String '%1$s'.")
    public SearchException malformedURL(String var1, @Cause MalformedURLException var2);

    @Message(id=700044, value="Error creating URI from String '%1$s'.")
    public SearchException badURISyntax(String var1, @Cause URISyntaxException var2);
}

