/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationPojoTypeMetadataContributorFactory;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorProvider;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

public class AnnotationMappingDefinitionContextImpl
implements AnnotationMappingDefinitionContext,
PojoMappingConfigurationContributor {
    private final PojoBootstrapIntrospector introspector;
    private final Set<Class<?>> annotatedTypes = new LinkedHashSet();
    private boolean annotatedTypeDiscoveryEnabled = false;

    public AnnotationMappingDefinitionContextImpl(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    public void setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.annotatedTypeDiscoveryEnabled = annotatedTypeDiscoveryEnabled;
    }

    @Override
    public AnnotationMappingDefinitionContext add(Class<?> annotatedType) {
        this.annotatedTypes.add(annotatedType);
        return this;
    }

    @Override
    public AnnotationMappingDefinitionContext add(Set<Class<?>> annotatedTypes) {
        this.annotatedTypes.addAll(annotatedTypes);
        return this;
    }

    @Override
    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> collector) {
        ContextualFailureCollector failureCollector = buildContext.getFailureCollector();
        AnnotationProcessorProvider annotationProcessorProvider = new AnnotationProcessorProvider((FailureCollector)failureCollector);
        AnnotationPojoTypeMetadataContributorFactory contributorFactory = new AnnotationPojoTypeMetadataContributorFactory(annotationProcessorProvider);
        HashSet alreadyContributedTypes = new HashSet();
        this.annotatedTypes.stream().map(this.introspector::getTypeModel).flatMap(PojoRawTypeModel::getAscendingSuperTypes).filter(alreadyContributedTypes::add).forEach(arg_0 -> AnnotationMappingDefinitionContextImpl.lambda$configure$0(collector, (FailureCollector)failureCollector, contributorFactory, arg_0));
        if (this.annotatedTypeDiscoveryEnabled) {
            PojoAnnotationTypeMetadataDiscoverer discoverer = new PojoAnnotationTypeMetadataDiscoverer(contributorFactory, alreadyContributedTypes);
            collector.collectDiscoverer((TypeMetadataDiscoverer)discoverer);
        }
    }

    private static /* synthetic */ void lambda$configure$0(MappingConfigurationCollector collector, FailureCollector failureCollector, AnnotationPojoTypeMetadataContributorFactory contributorFactory, PojoRawTypeModel typeModel) {
        Optional<Indexed> indexedAnnotation = typeModel.getAnnotationByType(Indexed.class);
        if (indexedAnnotation.isPresent()) {
            String defaultedIndexName = indexedAnnotation.get().index();
            if (defaultedIndexName.isEmpty()) {
                defaultedIndexName = typeModel.getJavaClass().getName();
            }
            try {
                collector.mapToIndex((MappableTypeModel)typeModel, defaultedIndexName);
            }
            catch (RuntimeException e) {
                failureCollector.withContext(PojoEventContexts.fromType(typeModel)).withContext(PojoEventContexts.fromAnnotation(indexedAnnotation.get())).add((Throwable)e);
            }
        }
        PojoTypeMetadataContributor contributor = contributorFactory.create(typeModel);
        collector.collectContributor((MappableTypeModel)typeModel, (Object)contributor);
    }

    private static class PojoAnnotationTypeMetadataDiscoverer
    implements TypeMetadataDiscoverer<PojoTypeMetadataContributor> {
        private final AnnotationPojoTypeMetadataContributorFactory contributorFactory;
        private final Set<PojoRawTypeModel<?>> alreadyContributedTypes;

        PojoAnnotationTypeMetadataDiscoverer(AnnotationPojoTypeMetadataContributorFactory contributorFactory, Set<PojoRawTypeModel<?>> alreadyContributedTypes) {
            this.contributorFactory = contributorFactory;
            this.alreadyContributedTypes = alreadyContributedTypes;
        }

        public Optional<PojoTypeMetadataContributor> discover(MappableTypeModel typeModel) {
            PojoRawTypeModel pojoTypeModel = (PojoRawTypeModel)typeModel;
            boolean neverContributed = this.alreadyContributedTypes.add(pojoTypeModel);
            if (neverContributed) {
                return Optional.of(this.contributorFactory.create(pojoTypeModel));
            }
            return Optional.empty();
        }
    }
}

