/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorHelper;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

abstract class TypeAnnotationProcessor<A extends Annotation> {
    final AnnotationProcessorHelper helper;

    TypeAnnotationProcessor(AnnotationProcessorHelper helper) {
        this.helper = helper;
    }

    public final void process(TypeMappingContext mappingContext, PojoRawTypeModel<?> typeModel) {
        this.processEach(mappingContext, typeModel, this.extractAnnotations(typeModel));
    }

    abstract Stream<? extends A> extractAnnotations(PojoRawTypeModel<?> var1);

    abstract void doProcess(TypeMappingContext var1, PojoRawTypeModel<?> var2, A var3);

    private void processEach(TypeMappingContext mappingContext, PojoRawTypeModel<?> typeModel, Stream<? extends A> annotations) {
        List annotationList = annotations.collect(Collectors.toList());
        for (Annotation annotation : annotationList) {
            try {
                this.doProcess(mappingContext, typeModel, annotation);
            }
            catch (RuntimeException e) {
                this.helper.getRootFailureCollector().withContext(PojoEventContexts.fromType(typeModel)).withContext(PojoEventContexts.fromAnnotation(annotation)).add((Throwable)e);
            }
        }
    }
}

