/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class FieldPropertyHandle
implements PropertyHandle {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final Field field;

    public FieldPropertyHandle(String name, Field field) {
        this.name = name;
        this.field = field;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.field + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(Object thiz) {
        try {
            return this.field.get(thiz);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw log.errorInvokingMember(this.field, thiz, e);
        }
    }

    @Override
    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        FieldPropertyHandle other = (FieldPropertyHandle)obj;
        return this.name.equals(other.name) && this.field.equals(other.field);
    }
}

